# RTPBC Patient - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Resource Profile: RTPBC Patient 

 
This profile constrains the Patient resource for carrying the limited patient information required in the consumer real-time pharmacy benefit check (RTPBC) process. 
The RTPBC profile further constrains certain US Core and base elements in a manner that is compatible with the the US Core profile (e.g., tightening element cardinality and further limiting allowed terminology). 

In the RTPBC exchange, the pertinent patient information is…

* given and family name
* gender
* date of birth
* address 


### Must Support elements in this profile

**Client and Responding systems**
 All of the elements identified above are marked Must Support though not all will be required in a given implementation (the address composite itself and each element within have a minimum cardinality of 0, to support differing patient lookup approaches). The appropriate cardinality for address elements is to be determined by implementers.

**Usages:**

* Use this Profile: [RTPBC Request Bundle](StructureDefinition-rtpbc-request-bundle.md) and [RTPBC Response Bundle](StructureDefinition-rtpbc-response-bundle.md)
* Refer to this Profile: [RTPBC Medication Request](StructureDefinition-rtpbc-medicationrequest.md), [RTPBC Request Using Claim](StructureDefinition-rtpbc-request-claim.md) and [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)
* Examples for this Profile: [Patient/rtpbc-patient-03](Patient-rtpbc-patient-03.md) and [Patient/rtpbc-patient-03ps](Patient-rtpbc-patient-03ps.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.carin-rtpbc|current/StructureDefinition/rtpbc-patient)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-rtpbc-patient.csv), [Excel](../StructureDefinition-rtpbc-patient.xlsx), [Schematron](../StructureDefinition-rtpbc-patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rtpbc-patient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-patient",
  "version" : "2.0.0",
  "name" : "RtpbcPatient",
  "title" : "RTPBC Patient",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-02T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This profile constrains the Patient resource for carrying the limited patient information required in the consumer real-time pharmacy benefit check (RTPBC) process. \n\nThe RTPBC profile further constrains certain US Core and base elements in a manner that is compatible with the the US Core profile (e.g., tightening element cardinality and further limiting allowed terminology).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient"
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "comment" : "Address may be used by the payer to identify the patient's insurance records"
      },
      {
        "id" : "Patient.address.state",
        "path" : "Patient.address.state",
        "binding" : {
          "strength" : "extensible",
          "description" : "RTPBC Two Letter State and Province Codes",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-state-and-province-code"
        }
      },
      {
        "id" : "Patient.address.country",
        "path" : "Patient.address.country",
        "comment" : "Populate when not a US address",
        "binding" : {
          "strength" : "extensible",
          "description" : "ISO 3166 2-character country codes",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-country-code"
        }
      },
      {
        "id" : "Patient.address.period",
        "path" : "Patient.address.period",
        "mustSupport" : true
      },
      {
        "id" : "Patient.communication",
        "path" : "Patient.communication",
        "mustSupport" : true
      },
      {
        "id" : "Patient.communication.language",
        "path" : "Patient.communication.language",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/simple-language"
        }
      }
    ]
  }
}

```
