# RTPBC Medication Request - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Resource Profile: RTPBC Medication Request 

 
This profile constrains the MedicationRequest resource to convey a subset of prescription information required in the consumer real-time pharmacy benefit check (RTPBC) process. The content specifies the prescribed product and quantity, and references the prescribing practitioner and the patient's preferred pharmacy. 
This profile differs from the US Core MedicationRequest in that it doesn't set the encounter or dosageInstruction elements as Must Support, because clients in the exchange will typically be mobile consumer applications that do not posess this information, and because that information is not pertinent to this use case. 

 
 The function of the MedicationRequest resource in this exchange is to convey information from the patient's prescription that has a bearing on pricing and coverage. This limited set of information consists of…

* the medication name and identifier
* prescribed quantity and unit of measure
* identification of the prescriber
* identification of the pharmacy
* whether product substitutions are allowed
* optionally, the days supply represented by the quantity 


### Must Support elements in this profile

**Client systems** 
 All of the elements identified above are marked Must Support…

* all of these except for days supply (.expectedSupplyDuration) have a minimum cardinality of 1 and MUST be populated in order to enable reliable results from the processor
* substitutions.allowed is expected to be populated as **false**, indicating that the processor must provide pricing and coverage for the specific requested medication. (The processor may additionally return information about alternative medications)
* dosageInstruction SHOULD be used when determining days supply

**Client and Responding systems** 

* days supply (.expectedSupplyDuration) can impact cost and coverage for a medication; however, patients may not be able to reliably provide it. Implementing partners MUST determine how or whether the element is to be used.

**Responding systems**

* MUST make use of all pertinent required MedicationRequest elements when determining pricing and coverage
* MAY use dosageInstruction when determining pricing and coverage

**Usages:**

* Use this Profile: [RTPBC Request Bundle](StructureDefinition-rtpbc-request-bundle.md)
* Refer to this Profile: [RTPBC Request Using Claim](StructureDefinition-rtpbc-request-claim.md)
* Examples for this Profile: [MedicationRequest/rtpbc-medicationrequest-03](MedicationRequest-rtpbc-medicationrequest-03.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.carin-rtpbc|current/StructureDefinition/rtpbc-medicationrequest)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-rtpbc-medicationrequest.csv), [Excel](../StructureDefinition-rtpbc-medicationrequest.xlsx), [Schematron](../StructureDefinition-rtpbc-medicationrequest.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rtpbc-medicationrequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-medicationrequest",
  "version" : "2.0.0",
  "name" : "RtpbcMedicationRequest",
  "title" : "RTPBC Medication Request",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-12-02T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This profile constrains the MedicationRequest resource to convey a subset of prescription information required in the consumer real-time pharmacy benefit check (RTPBC) process. The content specifies the prescribed product and quantity, and references the prescribing practitioner and the patient's preferred pharmacy. \n\nThis profile differs from the US Core MedicationRequest in that it doesn't set the encounter or dosageInstruction elements as Must Support, because clients in the exchange will typically be mobile consumer applications that do not posess this information, and because that information is not pertinent to this use case.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest"
      },
      {
        "id" : "MedicationRequest.status",
        "path" : "MedicationRequest.status",
        "label" : "Request Status",
        "short" : "Request Status",
        "definition" : "Status of the request for dispensing",
        "comment" : "Always equals 'draft'",
        "fixedCode" : "draft"
      },
      {
        "id" : "MedicationRequest.intent",
        "path" : "MedicationRequest.intent",
        "definition" : "Intent of the request for dispensing",
        "comment" : "Always equals 'proposal'",
        "fixedCode" : "proposal"
      },
      {
        "id" : "MedicationRequest.medication[x]",
        "path" : "MedicationRequest.medication[x]",
        "label" : "Prescribed Product",
        "short" : "Prescribed Product",
        "definition" : "A product identifier for the prescribed medication. Either an NDC11 or an RxNorm code for a prescribable product (representing drug name, strength and dose form)",
        "comment" : "The NDC11 is an 11-digit normalized format consisting of a 5-digit labeler segment, 4-digit product segment, and 2-digit package segment, with no dashes",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "RTPBC prescribable product codes (NDC11 and RxNorm)",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-prescribable-product-code"
        }
      },
      {
        "id" : "MedicationRequest.subject",
        "path" : "MedicationRequest.subject",
        "label" : "Patient",
        "short" : "Patient",
        "definition" : "The patient for whom this medication is being requested",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-patient"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "path" : "MedicationRequest.authoredOn",
        "definition" : "The actual or approximate date on which the prescription was written."
      },
      {
        "id" : "MedicationRequest.requester",
        "path" : "MedicationRequest.requester",
        "label" : "Prescriber",
        "short" : "Prescriber",
        "definition" : "The prescriber of the medication being requested",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.reasonCode",
        "path" : "MedicationRequest.reasonCode",
        "label" : "Diagnosis"
      },
      {
        "id" : "MedicationRequest.dispenseRequest",
        "path" : "MedicationRequest.dispenseRequest",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity",
        "path" : "MedicationRequest.dispenseRequest.quantity",
        "label" : "Prescribed Quantity",
        "short" : "Prescribed Quantity",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity.value",
        "path" : "MedicationRequest.dispenseRequest.quantity.value",
        "label" : "Quantity in Billing Units",
        "short" : "Quantity in Billing Units",
        "definition" : "The prescribed quantity in terms of the applicable billing unit of measure",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity.unit",
        "path" : "MedicationRequest.dispenseRequest.quantity.unit",
        "label" : "Billing unit of measure",
        "short" : "Billing unit of measure",
        "definition" : "Pharmacy metric billing unit: GM (gram), ML (milliliter) or EA (each)",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Billing quantity unity of measure",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-billing-unit"
        }
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "label" : "Days Supply",
        "short" : "Days Supply",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration.value",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration.value",
        "label" : "Days Supply Value",
        "short" : "Days Supply Value",
        "definition" : "The number of days the requested dispense quantity is intended to last",
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.dispenseRequest.performer",
        "path" : "MedicationRequest.dispenseRequest.performer",
        "label" : "Pharmacy",
        "short" : "Pharmacy",
        "definition" : "Proposed dispensing pharmacy.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.substitution",
        "path" : "MedicationRequest.substitution",
        "label" : "Substitution",
        "short" : "Substitution",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.substitution.allowed[x]",
        "path" : "MedicationRequest.substitution.allowed[x]",
        "label" : "Substitution Allowed",
        "short" : "Substitution Allowed",
        "definition" : "Whether or not the pharmacy may dispense a substitutable generic product instead of a requested branded product",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
