# RTPBC Coverage - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Resource Profile: RTPBC Coverage 

 
This profile constrains the Coverage resource for carrying the pharmacy benefit information required in the consumer real-time pharmacy benefit check process 

This profile constrains the Coverage resource to carry the member and and coverage identifiers that insurers use to locate the patient's specific plan coverage rules.

(Note: When the responder is a medication pricing source, the Coverage resource is not required).

The Coverage elements available to be used by the RTPBC process are:

* Coverage.subscriberId: Health plan subscriber ID
* Coverage.subscriber: Subscriber demographic information
* Coverage.identifier: Health plan member ID
* Coverage.beneficiary: Patient demographic information
* Coverage.class=rxid. Pharmacy benefit Member ID
* Coverage.class=rxgroup. Pharmacy benefit Group ID
* Coverage.class=rxbin. Pharmacy benefit BIN (IIN)
* Coverage.class=rxpcn. Pharmacy benefit PCN

Different insurers PBMs or other responders may require just a subset of these elements. Implementers may populate all elements for which information is available, or scope the population based the particular responder’s requirements.

### Must Support elements in this profile

**Client and Responding systems**

The elements identified as Must Support are the typical set used in US pharmacy benefit processing; client systems must enable these to be submitted in requests, and responders must be able to accept them to be used as appropriate during processing.

**Usages:**

* Use this Profile: [RTPBC Request Bundle - Non-PHI](StructureDefinition-rtpbc-request-bundle-non-phi.md) and [RTPBC Request Bundle](StructureDefinition-rtpbc-request-bundle.md)
* Refer to this Profile: [RTPBC Request Using Claim - Non-PHI](StructureDefinition-rtpbc-request-claim-non-phi.md) and [RTPBC Request Using Claim](StructureDefinition-rtpbc-request-claim.md)
* Examples for this Profile: [Coverage/rtpbc-coverage-01](Coverage-rtpbc-coverage-01.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.carin-rtpbc|current/StructureDefinition/rtpbc-coverage)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-rtpbc-coverage.csv), [Excel](../StructureDefinition-rtpbc-coverage.xlsx), [Schematron](../StructureDefinition-rtpbc-coverage.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rtpbc-coverage",
  "meta" : {
    "lastUpdated" : "2019-12-08T00:00:00-05:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-coverage",
  "version" : "2.0.0",
  "name" : "RtpbcCoverage",
  "title" : "RTPBC Coverage",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-12-02T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This profile constrains the Coverage resource for carrying the pharmacy benefit information required in the consumer real-time pharmacy benefit check process",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cdanetv4",
      "uri" : "http://www.cda-adc.ca/en/services/cdanet/",
      "name" : "Canadian Dental Association eclaims standard"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "cpha3pharm",
      "uri" : "http://www.pharmacists.ca/",
      "name" : "Canadian Pharmacy Associaiton eclaims standard"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Coverage",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Coverage",
        "path" : "Coverage"
      },
      {
        "id" : "Coverage.subscriberId",
        "path" : "Coverage.subscriberId",
        "label" : "Health Plan Cardholder ID",
        "short" : "Health Plan Cardholder ID",
        "comment" : "Either *PBM Member ID* (.class.type = 'rxid') or *Subscriber ID* must be populated"
      },
      {
        "id" : "Coverage.payor.identifier",
        "path" : "Coverage.payor.identifier",
        "label" : "Payer ID",
        "short" : "Payer ID",
        "definition" : "Payer ID as defined in the participants' environment. E.g., an identifier defined in an eligibility service to represent the payer.",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.payor.identifier.value",
        "path" : "Coverage.payor.identifier.value",
        "label" : "Payer ID Value",
        "short" : "Payer ID Value",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class",
        "path" : "Coverage.class",
        "label" : "Pharmacy coverage identifiers",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "description" : "Identifiers used by the payer/PBM to located the patient's coverage. IIN (BIN) number, Processor Control Number (PCN), pharmacy benefit Group ID and patient's PBM Member ID.",
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Pharmacy coverage identifiers",
        "definition" : "Identifiers used by the payer/PBM to located the patient's coverage. IIN (BIN) number, Processor Control Number (PCN), pharmacy benefit Group ID and patient's PBM Member ID.",
        "comment" : "Populate with identifiers retrieved from an eligibility service or other source agreed between trading partners"
      },
      {
        "id" : "Coverage.class.type",
        "path" : "Coverage.class.type",
        "binding" : {
          "strength" : "extensible",
          "description" : "Coverage Class Codes",
          "valueSet" : "http://hl7.org/fhir/ValueSet/coverage-class"
        }
      },
      {
        "id" : "Coverage.class:bin",
        "path" : "Coverage.class",
        "sliceName" : "bin",
        "label" : "IIN (BIN) number",
        "short" : "IIN (BIN) number",
        "comment" : "Populate as agreed between trading partners",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:bin.type",
        "path" : "Coverage.class.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
              "code" : "rxbin"
            }
          ]
        }
      },
      {
        "id" : "Coverage.class:pcn",
        "path" : "Coverage.class",
        "sliceName" : "pcn",
        "label" : "Processor Control Number (PCN)",
        "short" : "Processor Control Number (PCN)",
        "comment" : "Populate as agreed between trading partners",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:pcn.type",
        "path" : "Coverage.class.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
              "code" : "rxpcn"
            }
          ]
        }
      },
      {
        "id" : "Coverage.class:rxgroup-id",
        "path" : "Coverage.class",
        "sliceName" : "rxgroup-id",
        "label" : "Pharmacy Benefit Group ID",
        "short" : "Pharmacy Benefit Group ID",
        "definition" : "The patient's Group ID associated with their pharmacy benefit",
        "comment" : "Populate as agreed between trading partners",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:rxgroup-id.type",
        "path" : "Coverage.class.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
              "code" : "rxgroup"
            }
          ]
        }
      },
      {
        "id" : "Coverage.class:pbm-member-id",
        "path" : "Coverage.class",
        "sliceName" : "pbm-member-id",
        "label" : "PBM Member ID",
        "short" : "PBM Member ID",
        "definition" : "The patient's pharmacy benefit member ID (which may differ from their overall health insurance ID)",
        "comment" : "Populate as agreed between trading partners",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.class:pbm-member-id.type",
        "path" : "Coverage.class.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
              "code" : "rxid"
            }
          ]
        }
      }
    ]
  }
}

```
