# RTPBC benefitRestriction Extension - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Extension: RTPBC benefitRestriction Extension 

This extension conveys benefit restrictions that may apply to a prescription product and pharmacy combination.

**Context of Use**

This extension enables a real-time pharmacy benefit check responder to indicate one or more benefit restrictions that apply to:

* the requested medication and pharmacy
* an alternative medication and pharmacy

Values conveyed in this extension are defined in the [RTPBC Benefit Restriction](ValueSet-rtpbc-benefit-restriction.md) value set.

**Usage info**

**Usages:**

* Use this Extension: [RTPBC Response Using ClaimResponse](StructureDefinition-rtpbc-response-claimresponse.md)
* Examples for this Extension: [Bundle/rtpbc-bundle-response-03](Bundle-rtpbc-bundle-response-03.md), [ClaimResponse/rtpbc-claim-response-03](ClaimResponse-rtpbc-claim-response-03.md) and [ClaimResponse/rtpbc-claim-response-not-covered](ClaimResponse-rtpbc-claim-response-not-covered.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.carin-rtpbc|current/StructureDefinition/rtpbc-benefitRestriction)

### Formal Views of Extension Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-rtpbc-benefitRestriction.csv), [Excel](../StructureDefinition-rtpbc-benefitRestriction.xlsx), [Schematron](../StructureDefinition-rtpbc-benefitRestriction.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rtpbc-benefitRestriction",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-benefitRestriction",
  "version" : "2.0.0",
  "name" : "RtpbcExtensionBenefitRestriction",
  "title" : "RTPBC benefitRestriction Extension",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This extension conveys benefit restrictions that may apply to a prescription product and pharmacy combination.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ClaimResponse.item"
    },
    {
      "type" : "element",
      "expression" : "ClaimResponse.addItem"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Benefit restriction.",
        "definition" : "Benefit restrictions that may apply to a prescription product and pharmacy combination."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-benefitRestriction"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/carin-rtpbc/ValueSet/rtpbc-benefit-restriction"
        }
      }
    ]
  }
}

```
