# rtpbc-patient-03 - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example Patient: rtpbc-patient-03

### Example RTPBC Patient

In this example:

* the patient's name is Jane Doe
* the patient's date of birth is 1975-12-05
* the patient's address is ````100Oak Court Madison WI53510US````

 <!–

–> 

Language: en

Profile: [RTPBC Patient](StructureDefinition-rtpbc-patient.md)

Jane Doe Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)

-------

| | |
| :--- | :--- |
| Contact Detail | 100 Oak Court Madison WI 53510 US |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "rtpbc-patient-03",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-patient"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PI",
            "display" : "Patient internal identifier"
          }
        ],
        "text" : "Patient internal identifier"
      },
      "system" : "http://example.org/MyPatientApp",
      "value" : "30455"
    }
  ],
  "name" : [
    {
      "family" : "Doe",
      "given" : ["Jane"]
    }
  ],
  "gender" : "female",
  "birthDate" : "1975-12-05",
  "address" : [
    {
      "line" : ["100 Oak Court"],
      "city" : "Madison",
      "state" : "WI",
      "postalCode" : "53510",
      "country" : "US"
    }
  ]
}

```
