# rtpbc-organization-03m - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example Organization: rtpbc-organization-03m

### Example RTPBC Pharmacy (using Organization resource)

In this example:

* the pharmacy name is My Mail Service Pharmacy
* the pharmacy's NPI is 5515515515 (an NCPDP ID can optionally be included)

Language: en

Profile: [RTPBC Pharmacy Organization](StructureDefinition-rtpbc-pharmacy-organization.md)

**identifier**: [NCPDP Provider Identification Number](http://terminology.hl7.org/5.5.0/NamingSystem-NCPDPProviderIdentificationNumber.html)/0999029

**active**: true

**type**: Mail Order

**name**: My Mail Service Pharmacy

**telecom**: ph: 5551234567

**address**: 10001 Oakland Road Milwaukee WI 54444 US 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "rtpbc-organization-03m",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-pharmacy-organization"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://terminology.hl7.org/CodeSystem/NCPDPProviderIdentificationNumber",
      "value" : "0999029"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/NCPDPPharmacyType",
          "code" : "M",
          "display" : "Mail Order"
        }
      ]
    }
  ],
  "name" : "My Mail Service Pharmacy",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "5551234567"
    }
  ],
  "address" : [
    {
      "line" : ["10001 Oakland Road"],
      "city" : "Milwaukee",
      "state" : "WI",
      "postalCode" : "54444",
      "country" : "US"
    }
  ]
}

```
