# rtpbc-organization-03 - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example Organization: rtpbc-organization-03

### Example RTPBC Pharmacy (using Organization resource)

In this example:

* the pharmacy name is Hometown Drug
* the pharmacy's NPI is 9876543210 (an NCPDP ID can optionally be included)

Language: en

Profile: [RTPBC Pharmacy Organization](StructureDefinition-rtpbc-pharmacy-organization.md)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/5.5.0/NamingSystem-npi.html)/9876543213

**active**: true

**type**: Retail

**name**: Hometown Drug

**telecom**: ph: 6081234567

**address**: 900 9th Street Madison WI 53535 US 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "rtpbc-organization-03",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-pharmacy-organization"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "9876543213"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/NCPDPPharmacyType",
          "code" : "R",
          "display" : "Retail"
        }
      ]
    }
  ],
  "name" : "Hometown Drug",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "6081234567"
    }
  ],
  "address" : [
    {
      "line" : ["900 9th Street"],
      "city" : "Madison",
      "state" : "WI",
      "postalCode" : "53535",
      "country" : "US"
    }
  ]
}

```
