# rtpbc-coverage-01 - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example Coverage: rtpbc-coverage-01

Language: en

Profile: [RTPBC Coverage](StructureDefinition-rtpbc-coverage.md)

**status**: Active

**subscriberId**: 121212

**beneficiary**: [Jane Doe Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)](Patient-rtpbc-patient-03.md)

**relationship**: Self

**payor**: Identifier: Pharmacy Plans US

> **class****type**:RX BIN**value**: BIN001

> **class****type**:RX PCN**value**: PCN002

> **class****type**:RX Group**value**: GROUP0001

> **class****type**:RX Id**value**: MEMBER000001



## Resource Content

```json
{
  "resourceType" : "Coverage",
  "id" : "rtpbc-coverage-01",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-coverage"
    ]
  },
  "language" : "en",
  "status" : "active",
  "subscriberId" : "121212",
  "beneficiary" : {
    "reference" : "Patient/rtpbc-patient-03"
  },
  "relationship" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
        "code" : "self"
      }
    ]
  },
  "payor" : [
    {
      "identifier" : {
        "value" : "Pharmacy Plans US"
      }
    }
  ],
  "class" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
            "code" : "rxbin"
          }
        ]
      },
      "value" : "BIN001"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
            "code" : "rxpcn"
          }
        ]
      },
      "value" : "PCN002"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
            "code" : "rxgroup"
          }
        ]
      },
      "value" : "GROUP0001"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
            "code" : "rxid"
          }
        ]
      },
      "value" : "MEMBER000001"
    }
  ]
}

```
