# RTPBC Formulary Status Code System - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## CodeSystem: RTPBC Formulary Status Code System 

 
This code system defines formulary statuses that may apply to a prescription product evaluated in the Real-time Pharmacy Benefit Check (RTPBC) process. 

This Code system is referenced in the definition of the following value sets:

* [RtbpcFormularyStatusValueSet](ValueSet-rtpbc-formulary-status.md)

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "rtpbc-formulary-status",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-formulary-status",
  "version" : "2.0.0",
  "name" : "RtpbcFormularyStatusCodeSystem",
  "title" : "RTPBC Formulary Status Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-10-03T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This code system defines formulary statuses that may apply to a prescription product evaluated in the Real-time Pharmacy Benefit Check (RTPBC) process.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 9,
  "concept" : [
    {
      "code" : "B",
      "display" : "Brand Preferred",
      "definition" : "Indicates the payer prefers the brand over the generic"
    },
    {
      "code" : "C",
      "display" : "Carve-Out",
      "definition" : "This medication is processed by a third party, not the payer providing the formulary"
    },
    {
      "code" : "N",
      "display" : "Non-Formulary",
      "definition" : "Response code indicating that the prescribed drug is not included in the plan formulary"
    },
    {
      "code" : "O",
      "display" : "On Formulary",
      "definition" : "The medication submitted is included in the list of payable products in that patient's plan formulary but that there may be a more preferred product in the therapeutic category"
    },
    {
      "code" : "P",
      "display" : "On Formulary/Preferred",
      "definition" : "The medication is the preferred payable products in that patient's plan formulary"
    },
    {
      "code" : "U",
      "display" : "Unknown",
      "definition" : "Unknown"
    },
    {
      "code" : "X",
      "display" : "Non-Reimbursable without authorization",
      "definition" : "This medication is not covered although an exception or appeal process may exist"
    },
    {
      "code" : "Y",
      "display" : "Non-Reimbursable",
      "definition" : "The medication will never be reimbursable by the payer with no appeal process"
    },
    {
      "code" : "Z",
      "display" : "Zero Dollar Copay",
      "definition" : "This medication does not have a copay. The cost is $0 to the patient"
    }
  ]
}

```
