# RTPBC Event Type Code System - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## CodeSystem: RTPBC Event Type Code System 

 
This code system defines event types used in RTPBC message headers 

This code system establishes the event types used in Real-time Pharmacy Benefit Check message headers.

This Code system is referenced in the definition of the following value sets:

* [RtbpcEventTypeValueSet](ValueSet-rtpbc-event-type.md)

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "rtpbc-event-type",
  "meta" : {
    "lastUpdated" : "2020-05-23T00:00:00-05:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-event-type",
  "version" : "2.0.0",
  "name" : "RtpbcEventTypeCodeSystem",
  "title" : "RTPBC Event Type Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-08T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This code system defines event types used in RTPBC message headers",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 2,
  "concept" : [
    {
      "code" : "rtpbc-request",
      "display" : "RTPBC Request",
      "definition" : "Real-time Pharmacy Benefit Check (RTPBC) request"
    },
    {
      "code" : "rtpbc-response",
      "display" : "RTPBC Response",
      "definition" : "Real-time Pharmacy Benefit Check (RTPBC) response"
    }
  ]
}

```
