# RTPBC Benefit Restriction Code System - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## CodeSystem: RTPBC Benefit Restriction Code System 

 
This code system defines a set of benefit restrictions that may apply to a prescription product and pharmacy combination evaluated in the Real-time Pharmacy Benefit Check (RTPBC) process. 

In order to be meaningful to patients, the system summarizes the range of coverage levels and restrictions into a smaller, more readily understandable group of values.

This Code system is referenced in the definition of the following value sets:

* [RtbpcBenefitRestrictionValueSet](ValueSet-rtpbc-benefit-restriction.md)

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "rtpbc-benefit-restriction",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-benefit-restriction",
  "version" : "2.0.0",
  "name" : "RtpbcBenefitRestrictionCodeSystem",
  "title" : "RTPBC Benefit Restriction Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-05-23T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This code system defines a set of benefit restrictions that may apply to a prescription product and pharmacy combination evaluated in the Real-time Pharmacy Benefit Check (RTPBC) process.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 11,
  "concept" : [
    {
      "code" : "covered",
      "display" : "Covered",
      "definition" : "Covered"
    },
    {
      "code" : "prior-auth",
      "display" : "Prior authorization required",
      "definition" : "Covered with restriction: Prior authorization required"
    },
    {
      "code" : "step-therapy",
      "display" : "Step therapy applies",
      "definition" : "Covered with restriction: Step therapy applies"
    },
    {
      "code" : "quantity-limit",
      "display" : "Quantity limit applies",
      "definition" : "Covered with restriction: Quantity limit applies"
    },
    {
      "code" : "pharmacy-restriction",
      "display" : "Pharmacy restriction applies",
      "definition" : "Covered with restriction: Pharmacy restriction applies"
    },
    {
      "code" : "other-restriction",
      "display" : "Other restriction applies",
      "definition" : "Covered with restriction: Other restriction applies"
    },
    {
      "code" : "not-covered",
      "display" : "Not covered",
      "definition" : "Not covered"
    },
    {
      "code" : "additional-fills-not-covered",
      "display" : "Additional fills not covered",
      "definition" : "Additional fills are not covered"
    },
    {
      "code" : "fill-too-soon",
      "display" : "Fill too soon",
      "definition" : "Fill too soon"
    },
    {
      "code" : "days-supply-limitation",
      "display" : "Days supply limitation for product/service",
      "definition" : "Days supply limitation for the product/service"
    },
    {
      "code" : "route-not-covered",
      "display" : "Route of administration not covered",
      "definition" : "Route of administration is not covered"
    }
  ]
}

```
