# rtpbc-claim-non-phi-1 - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example Claim: rtpbc-claim-non-phi-1

Language: en

Profile: [RTPBC Request Using Claim - Non-PHI](StructureDefinition-rtpbc-request-claim-non-phi.md)

**identifier**: rtpbc-non-phi-1

**status**: Active

**type**: Pharmacy

**use**: Predetermination

**patient**: [Anonymous Patient (no stated gender), DoB Unknown](Patient-rtpbc-patient-non-phi-1.md)

**created**: 2025-11-01 11:20:54-0500

**provider**: [Organization Hometown Drug](Organization-rtpbc-organization-03.md)

**priority**: Normal

**prescription**: [MedicationRequest: status = draft; intent = proposal; reported[x] = true; medication[x] = ; authoredOn = 2025-11-01](MedicationRequest-rtpbc-medicationrequest-non-phi-1.md)

### CareTeams

| | | |
| :--- | :--- | :--- |
| - | **Sequence** | **Provider** |
| * | 1 | Masked |

### Insurances

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Focal** | **Coverage** |
| * | 1 | true | Masked |

### Items

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Sequence** | **CareTeamSequence** | **ProductOrService** | **Quantity** |
| * | 1 | 1 | Prozac 10mg Capsule | 60 {Each} |



## Resource Content

```json
{
  "resourceType" : "Claim",
  "id" : "rtpbc-claim-non-phi-1",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-request-claim-non-phi"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "value" : "rtpbc-non-phi-1"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "pharmacy",
        "display" : "Pharmacy"
      }
    ]
  },
  "use" : "predetermination",
  "patient" : {
    "reference" : "Patient/rtpbc-patient-non-phi-1"
  },
  "created" : "2025-11-01T11:20:54-05:00",
  "provider" : {
    "reference" : "Organization/rtpbc-organization-03"
  },
  "priority" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
        "code" : "normal",
        "display" : "Normal"
      }
    ]
  },
  "prescription" : {
    "reference" : "MedicationRequest/rtpbc-medicationrequest-non-phi-1"
  },
  "careTeam" : [
    {
      "sequence" : 1,
      "provider" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "masked"
          }
        ],
        "display" : "Masked"
      }
    }
  ],
  "insurance" : [
    {
      "sequence" : 1,
      "focal" : true,
      "coverage" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
            "valueCode" : "masked"
          }
        ],
        "display" : "Masked"
      }
    }
  ],
  "item" : [
    {
      "sequence" : 1,
      "careTeamSequence" : [1],
      "productOrService" : {
        "text" : "Prozac 10mg Capsule"
      },
      "quantity" : {
        "value" : 60,
        "unit" : "{Each}"
      }
    }
  ]
}

```
