# RTPBC Requester Capability Statement - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## CapabilityStatement: RTPBC Requester Capability Statement 

 
This CapabilityStatement describes the expected capabilities of a client system submitting a Real-time Pharmacy Benefit Check (RTPBC) request using the`$process-message`operation. 

### RTPBC Requester

**SHALL**: 

* Support at least one use case defined in this Guide and listed in the [Use Cases](use_cases.md) Section
* Implement the RESTful behavior according to the HL7 FHIR specification
* Support the JSON source format

**SHOULD**: 

* Support the XML source format
* Identify the RTPBC profiles supported as part of the FHIR `meta.profile` attribute for each instance

 [Raw OpenAPI-Swagger Definition file](../rtpbc-requester.openapi.json) | [Download](../rtpbc-requester.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "rtpbc-requester",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/carin-rtpbc/ImplementationGuide/hl7.fhir.us.carin-rtpbc"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/carin-rtpbc/CapabilityStatement/rtpbc-requester",
  "version" : "2.0.0",
  "name" : "RtpbcRequesterCapabilityStatement",
  "title" : "RTPBC Requester Capability Statement",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-08T00:00:00-05:00",
  "publisher" : "HL7 International / Pharmacy",
  "contact" : [
    {
      "name" : "HL7 International / Pharmacy",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/medication"
        }
      ]
    },
    {
      "name" : "Frank McKinney",
      "telecom" : [
        {
          "system" : "email",
          "value" : "fm@frankmckinney.com"
        }
      ]
    }
  ],
  "description" : "This CapabilityStatement describes the expected capabilities of a client system submitting a Real-time Pharmacy Benefit Check (RTPBC) request using the `$process-message` operation.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["xml", "json"],
  "patchFormat" : ["application/json-patch+json"],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "RTPBC Requester **SHALL**: 1. Support at least one use case defined in this IG and listed in the Use Cases section. 2. Implement the RESTful behavior according to the FHIR specification. 3. Support the JSON source format.  RTPBC Requester **SHOULD**: 1. Support the XML source format. 2. Identify the RTPBC profiles supported as part of the FHIR `meta.profile` attribute for each instance.",
      "security" : {
        "description" : "Implementers are expected to follow core FHIR security principles (https://www.hl7.org/fhir/security.html).In addition, the FHIR Security and Privacy Module (http://hl7.org/fhir/R4/secpriv-module.html) describes how to protect patient privacy."
      }
    }
  ]
}

```
