# rtpbc-bundle-response-price-source - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example Bundle: rtpbc-bundle-response-price-source

### RTPBC response bundle returned by a pricing source

In this example:

* the client is a patient application
* the server is a medication pricing source vendor
* the response is returned as a Bundle containing a ClaimResponse and supporting resources, in response to a $process-message operation

Content:

* the requested medication is Prozac 10mg capsule, 60 capsules, and the requested pharmacy is Hometown Drug. Adjudication returned in the ClaimResponse.item composite
* the .item contains patient costs for the requested drug and pharmacy combination
* the .addItem composite holds an alternative fulfillment (the requested drug at a different pharmacy). Adjudication is returned in the ClaimResponse.addItem composite
* a pharmacy Organization resource describes the alternative pharmacy option identified by the processor



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "rtpbc-bundle-response-price-source",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-response-bundle"
    ]
  },
  "language" : "en",
  "type" : "message",
  "timestamp" : "2019-11-15T13:10:15-05:00",
  "entry" : [
    {
      "fullUrl" : "http://example.org/my-app/MessageHeader/rtpbc-messageheader-response-03ps",
      "resource" : {
        "resourceType" : "MessageHeader",
        "id" : "rtpbc-messageheader-response-03ps",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-response-messageheader"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MessageHeader_rtpbc-messageheader-response-03ps\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MessageHeader rtpbc-messageheader-response-03ps</b></p><a name=\"rtpbc-messageheader-response-03ps\"> </a><a name=\"hcrtpbc-messageheader-response-03ps\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-response-messageheader.html\">RTPBC Response MessageHeader</a></p></div><p><b>event</b>: <a href=\"CodeSystem-rtpbc-event-type.html#rtpbc-event-type-rtpbc-response\">RTPBC Event Type Code System: rtpbc-response</a> (RTPBC Response)</p><h3>Sources</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Name</b></td><td><b>Endpoint</b></td></tr><tr><td style=\"display: none\">*</td><td>GoodPricing</td><td><a href=\"http://example.org/GoodPricing/fhir\">http://example.org/GoodPricing/fhir</a></td></tr></table><h3>Responses</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Identifier</b></td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td>rtpbc-messageheader-request-03</td><td>OK</td></tr></table><p><b>focus</b>: <a href=\"Bundle-rtpbc-bundle-response-price-source.html#http-//example.org/my-app/ClaimResponse/rtpbc-claim-response-03-price-source\">ClaimResponse: identifier = rtpbc-03-response-price-source; status = active; type = Pharmacy; use = predetermination; created = 2019-11-01 11:20:59-0500; outcome = complete; disposition = Processed successfully</a></p><p><b>definition</b>: <a href=\"MessageDefinition-rtpbc-response.html\">RTPBC Response Message Definition</a></p></div>"
        },
        "eventCoding" : {
          "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-event-type",
          "code" : "rtpbc-response",
          "display" : "RTPBC Response"
        },
        "source" : {
          "name" : "GoodPricing",
          "endpoint" : "http://example.org/GoodPricing/fhir"
        },
        "response" : {
          "identifier" : "rtpbc-messageheader-request-03",
          "code" : "ok"
        },
        "focus" : [
          {
            "reference" : "http://example.org/my-app/ClaimResponse/rtpbc-claim-response-03-price-source"
          }
        ],
        "definition" : "http://hl7.org/fhir/us/carin-rtpbc/MessageDefinition/rtpbc-response"
      }
    },
    {
      "fullUrl" : "http://example.org/my-app/ClaimResponse/rtpbc-claim-response-03-price-source",
      "resource" : {
        "resourceType" : "ClaimResponse",
        "id" : "rtpbc-claim-response-03-price-source",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-response-claimresponse"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ClaimResponse_rtpbc-claim-response-03-price-source\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ClaimResponse rtpbc-claim-response-03-price-source</b></p><a name=\"rtpbc-claim-response-03-price-source\"> </a><a name=\"hcrtpbc-claim-response-03-price-source\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-response-claimresponse.html\">RTPBC Response Using ClaimResponse</a></p></div><p><b>identifier</b>: rtpbc-03-response-price-source</p><p><b>status</b>: Active</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/claim-type pharmacy}\">Pharmacy</span></p><p><b>use</b>: Predetermination</p><p><b>patient</b>: <a href=\"Patient-rtpbc-patient-03ps.html\">Jane Doe  Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)</a></p><p><b>created</b>: 2019-11-01 11:20:59-0500</p><p><b>insurer</b>: Identifier: GoodPricing</p><p><b>request</b>: Identifier: rtpbc-03</p><p><b>outcome</b>: Processing Complete</p><p><b>disposition</b>: Processed successfully</p><blockquote><p><b>item</b></p><p><b>itemSequence</b>: 1</p><p><b>noteNumber</b>: 1</p><blockquote><p><b>adjudication</b></p><p><b>category</b>: <span title=\"Codes:{http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type cash-price}\">Full product cash price</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>105</td><td>United States dollar</td></tr></table></blockquote><blockquote><p><b>adjudication</b></p><p><b>category</b>: <span title=\"Codes:{http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type coupon-discount}\">Coupon discount amount</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>-20</td><td>United States dollar</td></tr></table></blockquote><blockquote><p><b>adjudication</b></p><p><b>category</b>: <span title=\"Codes:{http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type total}\">Total patient responsibility</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>85</td><td>United States dollar</td></tr></table></blockquote></blockquote><blockquote><p><b>addItem</b></p><p><b>RTPBC isAlternative Extension</b>: true</p><p><b>itemSequence</b>: 1</p><p><b>provider</b>: <a href=\"Organization-rtpbc-organization-03ps.html\">Organization Home Drugs</a></p><p><b>productOrService</b>: <span title=\"Codes:{http://www.nlm.nih.gov/research/umls/rxnorm 205535}\">fluoxetine 10 MG Oral Capsule [Prozac]</span></p><p><b>quantity</b>: 60 {Each}</p><blockquote><p><b>adjudication</b></p><p><b>category</b>: <span title=\"Codes:{http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type cash-price}\">Full product cash price</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>50</td><td>United States dollar</td></tr></table></blockquote><blockquote><p><b>adjudication</b></p><p><b>category</b>: <span title=\"Codes:{http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type coupon-discount}\">Coupon discount amount</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>-10</td><td>United States dollar</td></tr></table></blockquote><blockquote><p><b>adjudication</b></p><p><b>category</b>: <span title=\"Codes:{http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type total}\">Total patient responsibility</span></p><h3>Amounts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Value</b></td><td><b>Currency</b></td></tr><tr><td style=\"display: none\">*</td><td>40</td><td>United States dollar</td></tr></table></blockquote></blockquote></div>"
        },
        "identifier" : [
          {
            "value" : "rtpbc-03-response-price-source"
          }
        ],
        "status" : "active",
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
              "code" : "pharmacy",
              "display" : "Pharmacy"
            }
          ]
        },
        "use" : "predetermination",
        "patient" : {
          "reference" : "Patient/rtpbc-patient-03ps"
        },
        "created" : "2019-11-01T11:20:59-05:00",
        "insurer" : {
          "identifier" : {
            "value" : "GoodPricing"
          }
        },
        "request" : {
          "identifier" : {
            "value" : "rtpbc-03"
          }
        },
        "outcome" : "complete",
        "disposition" : "Processed successfully",
        "item" : [
          {
            "itemSequence" : 1,
            "noteNumber" : [1],
            "adjudication" : [
              {
                "category" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                      "code" : "cash-price",
                      "display" : "Full product cash price"
                    }
                  ]
                },
                "amount" : {
                  "value" : 105,
                  "currency" : "USD"
                }
              },
              {
                "category" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                      "code" : "coupon-discount",
                      "display" : "Coupon discount amount"
                    }
                  ]
                },
                "amount" : {
                  "value" : -20,
                  "currency" : "USD"
                }
              },
              {
                "category" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                      "code" : "total",
                      "display" : "Total patient responsibility"
                    }
                  ]
                },
                "amount" : {
                  "value" : 85,
                  "currency" : "USD"
                }
              }
            ]
          }
        ],
        "addItem" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-isAlternative",
                "valueBoolean" : true
              }
            ],
            "itemSequence" : [1],
            "provider" : [
              {
                "reference" : "Organization/rtpbc-organization-03ps"
              }
            ],
            "productOrService" : {
              "coding" : [
                {
                  "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
                  "code" : "205535",
                  "display" : "fluoxetine 10 MG Oral Capsule [Prozac]"
                }
              ]
            },
            "quantity" : {
              "value" : 60,
              "unit" : "{Each}"
            },
            "adjudication" : [
              {
                "category" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                      "code" : "cash-price",
                      "display" : "Full product cash price"
                    }
                  ]
                },
                "amount" : {
                  "value" : 50,
                  "currency" : "USD"
                }
              },
              {
                "category" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                      "code" : "coupon-discount",
                      "display" : "Coupon discount amount"
                    }
                  ]
                },
                "amount" : {
                  "value" : -10,
                  "currency" : "USD"
                }
              },
              {
                "category" : {
                  "coding" : [
                    {
                      "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-patient-pay-type",
                      "code" : "total",
                      "display" : "Total patient responsibility"
                    }
                  ]
                },
                "amount" : {
                  "value" : 40,
                  "currency" : "USD"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/my-app/Patient/rtpbc-patient-03ps",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "rtpbc-patient-03ps",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-patient"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_rtpbc-patient-03ps\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient rtpbc-patient-03ps</b></p><a name=\"rtpbc-patient-03ps\"> </a><a name=\"hcrtpbc-patient-03ps\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-patient.html\">RTPBC Patient</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Jane Doe  Female, DoB: 1975-12-05 ( Patient internal identifier: 30455)</p><hr/></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PI",
                  "display" : "Patient internal identifier"
                }
              ],
              "text" : "Patient internal identifier"
            },
            "system" : "http://example.org/MyPatientApp",
            "value" : "30455"
          }
        ],
        "name" : [
          {
            "family" : "Doe",
            "given" : ["Jane"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1975-12-05"
      }
    },
    {
      "fullUrl" : "http://example.org/my-app/Organization/rtpbc-organization-03ps",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "rtpbc-organization-03ps",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-pharmacy-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_rtpbc-organization-03ps\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization rtpbc-organization-03ps</b></p><a name=\"rtpbc-organization-03ps\"> </a><a name=\"hcrtpbc-organization-03ps\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-pharmacy-organization.html\">RTPBC Pharmacy Organization</a></p></div><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/5.5.0/NamingSystem-NCPDPProviderIdentificationNumber.html\" title=\"A NCPDP assigned number that provides pharmacies with a unique, 7-digit national identifying number that assists pharmacies in their interactions with federal agencies and third party providers. The NCPDP Provider Identification Number was formerly known as the NABP (National Board of Pharmacy) number. NCPDP also enumerates licensed dispensing sites in the United States as part of its Alternate Site Enumeration Program Numbering System (ASEP). The purpose of this system is to enable a site to identify itself to all third party processors by one standard number, in order to adjudicate claims and receive reimbursement from prescription card programs.\">NCPDP Provider Identification Number</a>/0999123</p><p><b>active</b>: true</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/NCPDPPharmacyType R}\">Retail</span></p><p><b>name</b>: Home Drugs</p><p><b>telecom</b>: ph: 5556057672</p><p><b>address</b>: 101 1st St N Minneapolis MN 55401 </p></div>"
        },
        "identifier" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/NCPDPProviderIdentificationNumber",
            "value" : "0999123"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/NCPDPPharmacyType",
                "code" : "R",
                "display" : "Retail"
              }
            ]
          }
        ],
        "name" : "Home Drugs",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "5556057672"
          }
        ],
        "address" : [
          {
            "line" : ["101 1st St N"],
            "city" : "Minneapolis",
            "state" : "MN",
            "postalCode" : "55401"
          }
        ]
      }
    }
  ]
}

```
