# rtpbc-bundle-request-non-phi-2 - Consumer Real-Time Pharmacy Benefit Check FHIR IG v2.0.0

## Example Bundle: rtpbc-bundle-request-non-phi-2



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "rtpbc-bundle-request-non-phi-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-request-bundle-non-phi"
    ]
  },
  "language" : "en",
  "type" : "message",
  "timestamp" : "2025-11-15T13:10:13-05:00",
  "entry" : [
    {
      "fullUrl" : "http://example.org/my-app/MessageHeader/rtpbc-messageheader-request-non-phi-2",
      "resource" : {
        "resourceType" : "MessageHeader",
        "id" : "rtpbc-messageheader-request-non-phi-2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-request-messageheader"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MessageHeader_rtpbc-messageheader-request-non-phi-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MessageHeader rtpbc-messageheader-request-non-phi-2</b></p><a name=\"rtpbc-messageheader-request-non-phi-2\"> </a><a name=\"hcrtpbc-messageheader-request-non-phi-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-request-messageheader.html\">RTPBC Request MessageHeader</a></p></div><p><b>event</b>: <a href=\"CodeSystem-rtpbc-event-type.html#rtpbc-event-type-rtpbc-request\">RTPBC Event Type Code System: rtpbc-request</a> (RTPBC Request)</p><h3>Sources</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Name</b></td><td><b>Endpoint</b></td></tr><tr><td style=\"display: none\">*</td><td>MyPatientApp</td><td><a href=\"http://example.org/MyPatientApp\">http://example.org/MyPatientApp</a></td></tr></table><p><b>focus</b>: <a href=\"Bundle-rtpbc-bundle-request-non-phi-2.html#http-//example.org/my-app/Claim/rtpbc-claim-non-phi-2\">Claim: identifier = rtpbc-non-phi-2; status = active; type = Pharmacy; use = predetermination; created = 2025-11-01 11:20:54-0500; priority = Normal</a></p><p><b>definition</b>: <a href=\"MessageDefinition-rtpbc-request.html\">RTPBC Request Message Definition</a></p></div>"
        },
        "eventCoding" : {
          "system" : "http://hl7.org/fhir/us/carin-rtpbc/CodeSystem/rtpbc-event-type",
          "code" : "rtpbc-request",
          "display" : "RTPBC Request"
        },
        "source" : {
          "name" : "MyPatientApp",
          "endpoint" : "http://example.org/MyPatientApp"
        },
        "focus" : [
          {
            "reference" : "http://example.org/my-app/Claim/rtpbc-claim-non-phi-2"
          }
        ],
        "definition" : "http://hl7.org/fhir/us/carin-rtpbc/MessageDefinition/rtpbc-request"
      }
    },
    {
      "fullUrl" : "http://example.org/my-app/Claim/rtpbc-claim-non-phi-2",
      "resource" : {
        "resourceType" : "Claim",
        "id" : "rtpbc-claim-non-phi-2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-request-claim-non-phi"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Claim_rtpbc-claim-non-phi-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Claim rtpbc-claim-non-phi-2</b></p><a name=\"rtpbc-claim-non-phi-2\"> </a><a name=\"hcrtpbc-claim-non-phi-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-request-claim-non-phi.html\">RTPBC Request Using Claim - Non-PHI</a></p></div><p><b>identifier</b>: rtpbc-non-phi-2</p><p><b>status</b>: Active</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/claim-type pharmacy}\">Pharmacy</span></p><p><b>use</b>: Predetermination</p><p><b>patient</b>: unspecified</p><p><b>created</b>: 2025-11-01 11:20:54-0500</p><p><b>provider</b>: <a href=\"Organization-rtpbc-organization-03.html\">Organization Hometown Drug</a></p><p><b>priority</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/processpriority normal}\">Normal</span></p><p><b>prescription</b>: <a href=\"MedicationRequest-rtpbc-medicationrequest-non-phi-2.html\">MedicationRequest: status = draft; intent = proposal; reported[x] = true; medication[x] = ; authoredOn = 2025-11-01</a></p><h3>CareTeams</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Sequence</b></td><td><b>Provider</b></td></tr><tr><td style=\"display: none\">*</td><td>1</td><td>unspecified</td></tr></table><h3>Insurances</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Sequence</b></td><td><b>Focal</b></td><td><b>Coverage</b></td></tr><tr><td style=\"display: none\">*</td><td>1</td><td>true</td><td>unspecified</td></tr></table><h3>Items</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Sequence</b></td><td><b>CareTeamSequence</b></td><td><b>ProductOrService</b></td><td><b>Quantity</b></td></tr><tr><td style=\"display: none\">*</td><td>1</td><td>1</td><td><span title=\"Codes:\">Prozac 10mg Capsule</span></td><td>60 {Each}</td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "rtpbc-non-phi-2"
          }
        ],
        "status" : "active",
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
              "code" : "pharmacy",
              "display" : "Pharmacy"
            }
          ]
        },
        "use" : "predetermination",
        "patient" : {
          "display" : "unspecified"
        },
        "created" : "2025-11-01T11:20:54-05:00",
        "provider" : {
          "reference" : "Organization/rtpbc-organization-03"
        },
        "priority" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
              "code" : "normal",
              "display" : "Normal"
            }
          ]
        },
        "prescription" : {
          "reference" : "MedicationRequest/rtpbc-medicationrequest-non-phi-2"
        },
        "careTeam" : [
          {
            "sequence" : 1,
            "provider" : {
              "display" : "unspecified"
            }
          }
        ],
        "insurance" : [
          {
            "sequence" : 1,
            "focal" : true,
            "coverage" : {
              "display" : "unspecified"
            }
          }
        ],
        "item" : [
          {
            "sequence" : 1,
            "careTeamSequence" : [1],
            "productOrService" : {
              "text" : "Prozac 10mg Capsule"
            },
            "quantity" : {
              "value" : 60,
              "unit" : "{Each}"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/my-app/MedicationRequest/rtpbc-medicationrequest-non-phi-2",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "rtpbc-medicationrequest-non-phi-2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-medicationrequest-non-phi"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_rtpbc-medicationrequest-non-phi-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest rtpbc-medicationrequest-non-phi-2</b></p><a name=\"rtpbc-medicationrequest-non-phi-2\"> </a><a name=\"hcrtpbc-medicationrequest-non-phi-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-medicationrequest-non-phi.html\">RTPBC Medication Request - Non-PHI</a></p></div><p><b>status</b>: Draft</p><p><b>intent</b>: Proposal</p><p><b>reported</b>: true</p><p><b>medication</b>: <span title=\"Codes:\">Prozac 10mg Capsule</span></p><p><b>subject</b>: unspecified</p><p><b>authoredOn</b>: 2025-11-01</p><h3>DispenseRequests</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Quantity</b></td><td><b>Performer</b></td></tr><tr><td style=\"display: none\">*</td><td>60 {Each}</td><td><a href=\"Organization-rtpbc-organization-03.html\">Organization Hometown Drug</a></td></tr></table></div>"
        },
        "status" : "draft",
        "intent" : "proposal",
        "reportedBoolean" : true,
        "medicationCodeableConcept" : {
          "text" : "Prozac 10mg Capsule"
        },
        "subject" : {
          "display" : "unspecified"
        },
        "authoredOn" : "2025-11-01",
        "dispenseRequest" : {
          "quantity" : {
            "value" : 60,
            "unit" : "{Each}"
          },
          "performer" : {
            "reference" : "Organization/rtpbc-organization-03"
          }
        }
      }
    },
    {
      "fullUrl" : "http://example.org/my-app/Organization/rtpbc-organization-03",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "rtpbc-organization-03",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/carin-rtpbc/StructureDefinition/rtpbc-pharmacy-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_rtpbc-organization-03\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization rtpbc-organization-03</b></p><a name=\"rtpbc-organization-03\"> </a><a name=\"hcrtpbc-organization-03\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-rtpbc-pharmacy-organization.html\">RTPBC Pharmacy Organization</a></p></div><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/5.5.0/NamingSystem-npi.html\" title=\"National Provider Identifier\">United States National Provider Identifier</a>/9876543213</p><p><b>active</b>: true</p><p><b>type</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/NCPDPPharmacyType R}\">Retail</span></p><p><b>name</b>: Hometown Drug</p><p><b>telecom</b>: ph: 6081234567</p><p><b>address</b>: 900 9th Street Madison WI 53535 US </p></div>"
        },
        "identifier" : [
          {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "9876543213"
          }
        ],
        "active" : true,
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/NCPDPPharmacyType",
                "code" : "R",
                "display" : "Retail"
              }
            ]
          }
        ],
        "name" : "Hometown Drug",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "6081234567"
          }
        ],
        "address" : [
          {
            "line" : ["900 9th Street"],
            "city" : "Madison",
            "state" : "WI",
            "postalCode" : "53535",
            "country" : "US"
          }
        ]
      }
    }
  ]
}

```
