# US Pathology Observation - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Observation**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-us-pathology-observation-definitions.md) 
*  [Mappings](StructureDefinition-us-pathology-observation-mappings.md) 
*  [Examples](StructureDefinition-us-pathology-observation-examples.md) 
*  [XML](StructureDefinition-us-pathology-observation.profile.xml.md) 
*  [JSON](StructureDefinition-us-pathology-observation.profile.json.md) 
*  [TTL](StructureDefinition-us-pathology-observation.profile.ttl.md) 

## Resource Profile: US Pathology Observation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-observation | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USPathologyObservation |

 
This Observation profile is inspired by both[US Core Simple Observation](https://hl7.org/fhir/us/core/STU6.1/)and the[IHE SDC/eCP on FHIR Observation Profile](http://hl7.org/fhir/uv/ihe-sdc-ecc/StructureDefinition-ihe-sdc-ecc-Observation.html). It adds category to differentiate Section and Question Observations. Section(s) contain one or more hasMember relationships to Questions, will not have a value element, and have no derivedFrom relationships. Questions have a derivedFrom relationship with Section AND contain EITHER a value element OR one or more hasMember relationships. 

## Introduction

This US Pathology Observation profile is inspired by the [IHE SDC/eCP on FHIR Observation Profile](http://hl7.org/fhir/uv/ihe-sdc-ecc/StructureDefinition-ihe-sdc-ecc-Observation.html) which maps the CAP protocol’s structured elements into FHIR Observations. The profile defines how to capture pathology data from structured cancer protocols in a standardized FHIR format.

## Background

The IHE Structured Data Capture (SDC) standard, **IHE SDC eCP on FHIR**, uses a form-driven workflow to capture and encode data and then create FHIR Observations from the captured data. The College of American Pathologists (CAP) has developed and tested the IHE SDC IG for collection of data from electronic Cancer Protocols (eCPs) by means of Structured Data Capture templates with XML-based schema which enforces ordering, optionality and standardization.

## CAP Protocol Structure

* The CAP electronic Cancer Protocols (eCPs) templates utilize a structured format with several key components:
* **Sections**: Represent major divisions within the protocol (e.g., “SPECIMEN,” “TUMOR”) that organize related content.
* **Child Items**: Encapsulates questions, list fields, and sub-sections within a section.
* **Questions**: Individual data elements which store captured responses which are derived from sections
* **Ordering**: Indicated for each element through an order attribute (order = “27”) which explicitly defines the sequence of sections, questions, and responses.

## Data Structure Rules

### Category Slicing

The Observation resource is sliced based on the category element to distinguish between sections and questions:

* **category:section**: When this slice is used (indicating the Observation represents a section), the `code` element must use a value from the “CAP eCP Section Codes” ValueSet (binding: required).
* **category:question**: When this slice is used (indicating the Observation represents a question), the `code` element must use a value from the “CAP eCP Question Codes” ValueSet (binding: required).

This slicing approach enforces the appropriate terminology bindings based on whether the Observation represents a structural section or a specific question.

### Hierarchical Structure

* **Sections**: CAP protocol sections (e.g., “SPECIMEN,” “TUMOR”) are stored as Observations that act as a grouping container using hasMember, which references child Observations (i.e., questions within the section).
* **Parent-Child Relationships**: If a question belongs to a section, the section Observation references its child Observations using hasMember whereas the child references the parent through derivedFrom.

### Key Elements

* **category**: Specifies whether this is a Section (has no value) or a Question (has a value) 
* Must use the appropriate slice (section or question) from ObservationCategoryCodes
 
* **code**: Represents the CAP protocol section or question ID 
* For category:section, must come from the CAP eCP Section Codes ValueSet
* For category:question, must come from the CAP eCP Question Codes ValueSet
 
* **value[x]**: Stores responses for the question
* **derivedFrom**: References parent Observations, allowing hierarchical relationships between related responses
* **hasMember**: References child Observations, supporting nested data
* **component**: Stores additional data fields related to a question such as “Other (Specify)”

### Special Cases

* **Multiselect Questions**: If the question is Multiselect, multiple Observations with the same Question Code should be created.
* **Follow-up Fields**: If the question has a follow-up text or number entry field (e.g., “Other (Specify)”), the information from the textbox should be stored in the Observation.component.value, and the Observation.component.code should repeat the Observation.value as the sub-question.

**Usages:**

* Use this Profile: [US Pathology Bundle](StructureDefinition-us-pathology-bundle.md)
* Refer to this Profile: [US Pathology Composition Laboratory Report](StructureDefinition-us-pathology-composition.md), [US Pathology Diagnostic Report](StructureDefinition-us-pathology-diagnostic-report.md) and [US Pathology Observation](StructureDefinition-us-pathology-observation.md)
* Examples for this Profile: [Observation/observation-additional-dimension](Observation-observation-additional-dimension.md), [Observation/observation-additional-findings-specify](Observation-observation-additional-findings-specify.md), [Observation/observation-clock-position-8](Observation-observation-clock-position-8.md), [Observation/observation-clock-position](Observation-observation-clock-position.md)...Show 38 more,[Observation/observation-distant-metastasis-distant-sites](Observation-observation-distant-metastasis-distant-sites.md),[Observation/observation-distant-metastasis](Observation-observation-distant-metastasis.md),[Observation/observation-ductal-carcinoma](Observation-observation-ductal-carcinoma.md),[Observation/observation-glandular-differentiation](Observation-observation-glandular-differentiation.md),[Observation/observation-histologic-grade](Observation-observation-histologic-grade.md),[Observation/observation-histologic-type](Observation-observation-histologic-type.md),[Observation/observation-margins-closest-margin-to-invasive-carcinoma](Observation-observation-margins-closest-margin-to-invasive-carcinoma.md),[Observation/observation-margins-distance-to-closest-margin](Observation-observation-margins-distance-to-closest-margin.md),[Observation/observation-margins-margin-status-for-invasive-carcinoma](Observation-observation-margins-margin-status-for-invasive-carcinoma.md),[Observation/observation-mitotic-rate](Observation-observation-mitotic-rate.md),[Observation/observation-nuclear-pleomorphism](Observation-observation-nuclear-pleomorphism.md),[Observation/observation-overall-grade](Observation-observation-overall-grade.md),[Observation/observation-procedure-breast-excision](Observation-observation-procedure-breast-excision.md),[Observation/observation-ptnm-classification-pN-Category](Observation-observation-ptnm-classification-pN-Category.md),[Observation/observation-ptnm-classification-pT-Category](Observation-observation-ptnm-classification-pT-Category.md),[Observation/observation-regional-lymph-node-status](Observation-observation-regional-lymph-node-status.md),[Observation/observation-regional-lymph-nodes-number-examined](Observation-observation-regional-lymph-nodes-number-examined.md),[Observation/observation-regional-lymph-nodes-number-sentinel](Observation-observation-regional-lymph-nodes-number-sentinel.md),[Observation/observation-section-additional-findings](Observation-observation-section-additional-findings.md),[Observation/observation-section-comments](Observation-observation-section-comments.md),[Observation/observation-section-distant-metastasis](Observation-observation-section-distant-metastasis.md),[Observation/observation-section-lymph-nodes](Observation-observation-section-lymph-nodes.md),[Observation/observation-section-margins](Observation-observation-section-margins.md),[Observation/observation-section-ptnm-classification](Observation-observation-section-ptnm-classification.md),[Observation/observation-section-regional-lymph-nodes](Observation-observation-section-regional-lymph-nodes.md),[Observation/observation-section-special-studies](Observation-observation-section-special-studies.md),[Observation/observation-section-specimen](Observation-observation-section-specimen.md),[Observation/observation-section-tumor-extent](Observation-observation-section-tumor-extent.md),[Observation/observation-section-tumor](Observation-observation-section-tumor.md),[Observation/observation-special-studies-breast-biomarker](Observation-observation-special-studies-breast-biomarker.md),[Observation/observation-special-studies-estrogen-receptor-status](Observation-observation-special-studies-estrogen-receptor-status.md),[Observation/observation-special-studies-estrogen-receptor](Observation-observation-special-studies-estrogen-receptor.md),[Observation/observation-special-studies-her2](Observation-observation-special-studies-her2.md),[Observation/observation-special-studies-negative](Observation-observation-special-studies-negative.md),[Observation/observation-specimen-laterality](Observation-observation-specimen-laterality.md),[Observation/observation-tumor-focality](Observation-observation-tumor-focality.md),[Observation/observation-tumor-site](Observation-observation-tumor-site.md)and[Observation/observation-tumor-size](Observation-observation-tumor-size.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.cancer-reporting|current/StructureDefinition/us-pathology-observation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Key Elements Table](#tabs-key) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [USCoreSimpleObservationProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-simple-observation.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

#### Terminology Bindings

#### Constraints

This structure is derived from [USCoreSimpleObservationProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-simple-observation.html) 

**Summary**

Mandatory: 2 elements
 Must-Support: 5 elements

**Structures**

This structure refers to these other structures:

* [US Pathology Observation(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-observation)](StructureDefinition-us-pathology-observation.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.value[x]

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 **Differential View** 

This structure is derived from [USCoreSimpleObservationProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-simple-observation.html) 

#### Terminology Bindings (Differential)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [USCoreSimpleObservationProfile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-simple-observation.html) 

**Summary**

Mandatory: 2 elements
 Must-Support: 5 elements

**Structures**

This structure refers to these other structures:

* [US Pathology Observation(http://hl7.org/fhir/us/cancer-reporting/StructureDefinition/us-pathology-observation)](StructureDefinition-us-pathology-observation.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.value[x]

**[Maturity](http://hl7.org/fhir/versions.html#maturity)**: 2

 

Other representations of profile: [CSV](StructureDefinition-us-pathology-observation.csv), [Excel](StructureDefinition-us-pathology-observation.xlsx), [Schematron](StructureDefinition-us-pathology-observation.sch) 

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

