# US Pathology Observation - Examples - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Observation**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

*  [Content](StructureDefinition-us-pathology-observation.md) 
*  [Detailed Descriptions](StructureDefinition-us-pathology-observation-definitions.md) 
*  [Mappings](StructureDefinition-us-pathology-observation-mappings.md) 
*  [Examples](#) 
*  [XML](StructureDefinition-us-pathology-observation.profile.xml.md) 
*  [JSON](StructureDefinition-us-pathology-observation.profile.json.md) 
*  [TTL](StructureDefinition-us-pathology-observation.profile.ttl.md) 

## Resource Profile: USPathologyObservation - Examples

| | |
| :--- | :--- |
| *Page standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 |

Examples for the us-pathology-observation Profile.

| |
| :--- |
| [Additional Dimension Observation](Observation-observation-additional-dimension.md) |
| [Additional Findings Observation example](Observation-observation-additional-findings-specify.md) |
| [Specific Clock Position Observation (8 o'clock)](Observation-observation-clock-position-8.md) |
| [Observation for Clock Position General](Observation-observation-clock-position.md) |
| [Distant Metastasis Distant Site(s) Involved Observation example](Observation-observation-distant-metastasis-distant-sites.md) |
| [Distant Metastasis Observation example](Observation-observation-distant-metastasis.md) |
| [Ductal Carcinoma In Situ Observation Example](Observation-observation-ductal-carcinoma.md) |
| [Glandular/Tubular Differentiation Observation Example](Observation-observation-glandular-differentiation.md) |
| [Histologic Grade Observation Example](Observation-observation-histologic-grade.md) |
| [Histologic Type Observation example](Observation-observation-histologic-type.md) |
| [Closest Margin(s) to Invasive Carcinoma example](Observation-observation-margins-closest-margin-to-invasive-carcinoma.md) |
| [Margin Distance from Invasive Carcinoma to Closest Margin example](Observation-observation-margins-distance-to-closest-margin.md) |
| [Margin Status for Invasive Carcinoma Observation example](Observation-observation-margins-margin-status-for-invasive-carcinoma.md) |
| [Mitotic Rate Observation Example](Observation-observation-mitotic-rate.md) |
| [Nuclear Pleomorphism Observation Example](Observation-observation-nuclear-pleomorphism.md) |
| [Overall Grade Observation Example](Observation-observation-overall-grade.md) |
| [Breast Tissue Excision Observation Example](Observation-observation-procedure-breast-excision.md) |
| [PTNM Classification Observation example](Observation-observation-ptnm-classification-pN-Category.md) |
| [Regional Lymph Nodes PT Category Observation example](Observation-observation-ptnm-classification-pT-Category.md) |
| [Regional Lymph Nodes Status Observation example](Observation-observation-regional-lymph-node-status.md) |
| [Total Number of Lymph Nodes Examined (sentinel and non-sentinel) example](Observation-observation-regional-lymph-nodes-number-examined.md) |
| [Number of Sentinel Nodes Examined](Observation-observation-regional-lymph-nodes-number-sentinel.md) |
| [Additional Findings Section](Observation-observation-section-additional-findings.md) |
| [Comments Section](Observation-observation-section-comments.md) |
| [Distant Metastasis Section](Observation-observation-section-distant-metastasis.md) |
| [Lymph Nodes Section](Observation-observation-section-lymph-nodes.md) |
| [Margins Section](Observation-observation-section-margins.md) |
| [pTNM Classification Section](Observation-observation-section-ptnm-classification.md) |
| [Regional Lymph Nodes Section](Observation-observation-section-regional-lymph-nodes.md) |
| [Special Studies Section](Observation-observation-section-special-studies.md) |
| [Specimen Section](Observation-observation-section-specimen.md) |
| [Tumor Extent Observation Example](Observation-observation-section-tumor-extent.md) |
| [Tumor Section](Observation-observation-section-tumor.md) |
| [Breast Biomarker Testing Performed on Previous Biopsy](Observation-observation-special-studies-breast-biomarker.md) |
| [Estrogen Receptor (ER) Status](Observation-observation-special-studies-estrogen-receptor-status.md) |
| [Special Studies Estrogen Receptor](Observation-observation-special-studies-estrogen-receptor.md) |
| [HER2 Observation Example](Observation-observation-special-studies-her2.md) |
| [HER2 (by immunohistochemistry)](Observation-observation-special-studies-negative.md) |
| [Specimen Laterality Observation Example](Observation-observation-specimen-laterality.md) |
| [Tumor Focality Observation Example](Observation-observation-tumor-focality.md) |
| [General Tumor Site Observation](Observation-observation-tumor-site.md) |
| [Tumor Size Observation](Observation-observation-tumor-size.md) |

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

