# Tumor Size Observation - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Tumor Size Observation**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

*  [Narrative Content](#) 
*  [XML](Observation-observation-tumor-size.xml.md) 
*  [JSON](Observation-observation-tumor-size.json.md) 
*  [TTL](Observation-observation-tumor-size.ttl.md) 

## Example Observation: Tumor Size Observation

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**: [CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:66153175-f304-443e-99cb-4058f350248b

**status**: Final

**category**: Question

**code**: Tumor Size (Note E)

**subject**: [Annie Oakley](Patient-patient-OakleyAnnie.md)

**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)

**performer**: [PractitionerRole Primary Interpreter](PractitionerRole-practitionerrole-uspath-pathologist.md)

**value**: Greatest dimension of largest invasive focus greater than 1 mm (specify exact measurement in Millimeters (mm))

**hasMember**: [Observation Additional Dimension in Millimeters (mm)](Observation-observation-additional-dimension.md)

**derivedFrom**: [Observation TUMOR](Observation-observation-section-tumor.md)

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

