# Total Number of Lymph Nodes Examined (sentinel and non-sentinel) example - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Total Number of Lymph Nodes Examined (sentinel and non-sentinel) example**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

*  [Narrative Content](#) 
*  [XML](Observation-observation-regional-lymph-nodes-number-examined.xml.md) 
*  [JSON](Observation-observation-regional-lymph-nodes-number-examined.json.md) 
*  [TTL](Observation-observation-regional-lymph-nodes-number-examined.ttl.md) 

## Example Observation: Total Number of Lymph Nodes Examined (sentinel and non-sentinel) example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**: [CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:a903ae85-913a-4c9b-94cb-c6a1e00340e3

**status**: Final

**category**: Question

**code**: Total Number of Lymph Nodes Examined (sentinel and non-sentinel)

**subject**: [Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)

**effective**: 2025-03-18

**performer**: [Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)

**value**: Exact number (specify)

**derivedFrom**: [Observation Regional Lymph Node Status](Observation-observation-regional-lymph-node-status.md)

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

