# Ductal Carcinoma In Situ Observation Example - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Ductal Carcinoma In Situ Observation Example**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

*  [Narrative Content](#) 
*  [XML](Observation-observation-ductal-carcinoma.xml.md) 
*  [JSON](Observation-observation-ductal-carcinoma.json.md) 
*  [TTL](Observation-observation-ductal-carcinoma.ttl.md) 

## Example Observation: Ductal Carcinoma In Situ Observation Example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [US Pathology Observation](StructureDefinition-us-pathology-observation.md)

**identifier**: [CAPeCC](http://terminology.hl7.org/5.0.0/NamingSystem-CAPeCC.html)/urn:uuid:c2f916f9-7438-4ba6-9cba-9e9064edbe3c

**status**: Final

**category**: Question

**code**: Ductal Carcinoma In Situ (DCIS) (Note G)

**subject**: [Annie Oakley Female, DoB: 1990-06-01 ( MRN: AlaskaDLN#abc123 (use: usual, ))](Patient-patient-OakleyAnnie.md)

**effective**: 2025-03-18 14:52:02+0000 --> (ongoing)

**performer**: [Practitioner Wise Owl](Practitioner-practitioner-oncologist.md)

**value**: Not identified

**derivedFrom**: [Observation TUMOR](Observation-observation-section-tumor.md)

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

