# US Pathology Code System - Cancer Pathology Data Sharing v2.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Pathology Code System**

Cancer Pathology Data Sharing, published by HL7 International / Orders and Observations. This guide is not an authorized publication; it is the continuous build for version 2.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/cancer-reporting/](https://github.com/HL7/cancer-reporting/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/cancer-reporting/history.html)

*  [Narrative Content](#) 
*  [XML](CodeSystem-us-pathology-codesystem.xml.md) 
*  [JSON](CodeSystem-us-pathology-codesystem.json.md) 
*  [TTL](CodeSystem-us-pathology-codesystem.ttl.md) 

## CodeSystem: US Pathology Code System 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/cancer-reporting/CodeSystem/us-pathology-codesystem | *Version*:2.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Computable Name*:USPathologyCodeSystem |

 
US Pathology Code System 

 This Code system is referenced in the content logical definition of the following value sets: 

* [USPathologyFormCategoryCodes](ValueSet-us-pathology-form-category-codes.md)

This case-insensitive code system `http://hl7.org/fhir/us/cancer-reporting/CodeSystem/us-pathology-codesystem` defines the following codes:

 IG © 2025+ [HL7 International / Orders and Observations](http://www.hl7.org/Special/committees/orders) and [College of American Pathologists](https://smarthealthit.org). Package hl7.fhir.us.cancer-reporting#2.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-02 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/cancer-reporting/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

