# Rozsah použití a obsah - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Rozsah použití a obsah**

## Rozsah použití a obsah

### Definice pojmů

**Řidičské oprávnění (ŘO)**

* Dle `§ 80 zákona o silničním provozu` je ŘO oficiální dokument, který potvrzuje, že osoba splňuje všechny požadavky a podmínky stanovené zákonem pro řízení motorového vozidla.
* Tento doklad opravňuje držitele k řízení určité kategorie vozidla, přičemž každá kategorie odpovídá specifickým typům vozidel.
* ŘO získává osoba po úspěšném složení teoretických a praktických zkoušek a po absolvování lékařské prohlídky.

**Lékařský posudek / Elektronický lékařský posudek (ELP)**

* Lékařský posudek o zdravotní způsobilosti nebo o zdravotním stavu je dokument, který vydává poskytovatel zdravotních služeb (PZS) na žádost pacienta, který je posuzovanou osobou, nebo jiné k tomu oprávněné osoby po posouzení zdravotní způsobilosti, popřípadě zdravotního stavu posuzované osoby, posuzujícím lékařem.
* Lékařský posudek může vydat praktický lékař, odborný lékař nebo posudkový lékař. V některých případech musí být vypracován posudkovou komisí nebo jiným specializovaným zdravotnickým orgánem.
* Obecná problematika lékařských posudků je zakotvena především v `zákoně o specifických zdravotních službách hlava IV`.
* Obecné náležitosti současných lékařských posudků jsou uvedeny v `části 5 přílohy č. 1 k vyhlášce o zdravotnické dokumentaci`.
* Vyhláška o zdravotní způsobilosti k řízení motorových vozidel stanovuje podmínky zdravotní způsobilosti a postupy při vydávání posudků k řízení motorových vozidel.

**Posuzující lékař**

* Dle `§ 84 odst. 4 zákona o silničním provozu` je to lékař, který je oprávněn posuzovat zdravotní způsobilost k řízení motorových vozidel. Může to být: 
* Lékař se specializací v oboru všeobecného praktického lékařství nebo praktický lékař pro děti a dorost, který je registrovaným poskytovatelem ambulantní zdravotní péče.
* Lékař poskytovatel pracovnělékařských služeb.
* Lékař, který pracuje pro jiného poskytovatele ambulantní zdravotní péče, pokud posuzovaná osoba nemá registrujícího poskytovatele nebo poskytovatele pracovnělékařských služeb.
 

**Pacient/Posuzovaná osoba**

* Pacient je posuzovanou osobou, která podstupuje vyšetření či prohlídku a posouzení zdravotní způsobilosti k řízení motorového vozidla.
* Tato osoba může být žadatel o ŘO nebo držitel ŘO, jehož zdravotní stav je zkoumán lékařem v rámci posouzení, zda splňuje podmínky pro bezpečné řízení vozidla.

**Zdravotní způsobilost k řízení motorových vozidel**

* Dle `§ 84 odst. 1 zákona o silničním provozu` je zdravotní způsobilost k řízení motorových vozidel schopnost řidiče vykonávat řízení vozidla bez zdravotních problémů, které by ohrozily jeho bezpečnost nebo bezpečnost ostatních účastníků silničního provozu.
* Tento stav zahrnuje například normální zrak, sluch, psychickou stabilitu a fyzickou kondici. Zdravotní způsobilost posuzují lékaři při vyšetření a může být pravidelně kontrolována v závislosti na věku a zdravotním stavu řidiče.

### Obsah

#### Informační modely

##### Koncepční pohled

Elektronický lékařský posudek je rozdělen do několika částí: záhlaví dokumentu, které obsahuje administrativní údaje a obsah (tělo) samotného dokumentu.

###### Elektronické lékařské posudky

###### Hlavička dokumentu

###### Tělo dokumentu

### Struktura Elektronického lékařského posudku

#### Hlavička záznamu - administrativní údaje

**Identifikace pacienta**

Tento oddíl obsahuje základní údaje o pacientovi, včetně identifikátorů (RID/DRID), jména, příjmení, data narození, státní příslušnosti a dalších podpůrných údajů, které umožňují jednoznačnou identifikaci v českém národním kontextu.

**Autor - posuzující lékař**

Posuzujícím lékařem je lékař se specializovanou způsobilostí v oboru všeobecné praktické lékařství nebo v oboru praktické lékařství pro děti a dorost, pokud tento zákon nebo jiný právní předpis nestanoví jinak.

**Metadata dokumentu**

Obsahuje další administrativní informace o dokumentu – např. kategorie, verze, datum a čas vytvoření, stav dokumentu, jazyk a stupeň důvěrnosti.

**Elektronické podpisy**

Sekce určená pro elektronický podpis či časové razítko podle `zákona č. 327/2011 Sb., § 54a`.

#### Tělo posudku

**Lékařská prohlídka**

Nezbytným rozsahem lékařské prohlídky a pravidelné lékařské prohlídky je v případě posudku pro řidičské oprávnění:

1. zjištění o zdravotním stavu posuzované osoby s cíleným zaměřením na nemoci, které zdravotní způsobilost k řízení motorových vozidel vylučují nebo podmiňují; nemoci, které zdravotní způsobilost k řízení motorových vozidel vylučují nebo podmiňují, jsou stanoveny v`příloze č. 3 k vyhlášce č. 277/2004 Sb.`,
1. komplexní fyzikální vyšetření, a to včetně orientačního vyšetření sluchu, zrakové ostrosti a barvocitu, orientačního vyšetření zorného pole a rovnováhy a orientačního neurologického vyšetření, a to s cíleným zaměřením na zjištění příznaků nemoci uvedené v`příloze č. 3 k vyhlášce č. 277/2004 Sb.`.

**Lékařský posudek**

Posudek musí být jednoznačný a nesmí obsahovat diagnózu nemoci; vždy obsahuje náležitosti uvedené v posudku podle `přílohy č. 2 k vyhlášce č. 277/2004 Sb.`.

**Druh posudku**

Typový druh posudku. Například "Přezkoumání způsobilosti" pro řidičské oprávnění.

**Výsledek**

Výsledky klinických, laboratorních či odborných vyšetření, pokud jsou relevantní. Například v souvislosti s posudkem pro řidičské oprávnění lze posuzovanou osobu za zdravotně způsobilou k řízení motorových vozidel nebo za zdravotně způsobilou s podmínkou uznat za podmínek stanovených v zákoně, pokud na základě lékařské prohlídky nebo pravidelné lékařské prohlídky nebyla u této osoby zjištěna vada, stav nebo nemoc, která vylučuje zdravotní způsobilost k řízení motorových vozidel.

