# hl7.fhir.cz.elp#0.0.1: HL7 Czech Electronic medical report Implementation Guide

## Pages

* [Home](index.md)
* [Examples](examples.md)
* [Scope and content](scope-and-content.md)
* [Logical models](logical-models.md)
* [Background](background-cs.md)
* [Rozsah použití a obsah](scope-and-content-cs.md)
* [Mapování logického modelu hlavičky](elpHeader-map-cs.md)
* [Datová sada - logické modely](logical-models-cs.md)
* [Závislosti](dependencies-cs.md)
* [Dependencies](dependencies.md)
* [Electronic medical report Model map](elpBody-map.md)
* [Copyright](copyright.md)
* [Background](background.md)
* [Příklady](examples-cs.md)
* [Autorská práva](copyright-cs.md)
* [Authors](authors.md)
* [Header Model map](elpHeader-map.md)
* [Download](downloads-cs.md)
* [Model maps](model-map.md)
* [Mapování logického modelu](model-map-cs.md)
* [Workflow](workflow-cs.md)
* [Mapování logického modelu Elektronického lékařského posudku](elpBody-map-cs.md)
* [Autoři](authors-cs.md)
* [Artifacts](artifacts.md)
* [Download](downloads.md)
* [Workflow](workflow.md)
* [Případy užití](use-cases-cs.md)
* [Use cases](use-cases.md)

## Resources

### CodeSystems

* [Restriction clarification code system](CodeSystem-cz-restriction-clarification-elp-cs.md)
* [Restriction type code system](CodeSystem-cz-restriction-type-elp-cs.md)
* [Electronic medical report CodeSystem](CodeSystem-elp-ro--1.0.0.md)

### ValueSets

* [Appointment service category value set](ValueSet-cz-appointment-service-category-elp-vs.md)
* [Appointment service type value set](ValueSet-cz-appointment-service-type-elp-vs.md)
* [Category by driver value set](ValueSet-cz-category-by-driver-elp-vs.md)
* [Conclusion code value set](ValueSet-cz-conclusion-code-elp-vs.md)
* [Alternative Observation Code for ELP valueset](ValueSet-cz-observation-code-alt-elp-vs.md)
* [Observation Code for ELP valueset](ValueSet-cz-observation-code-elp-vs.md)
* [Restriction clarification value set](ValueSet-cz-restriction-clarification-elp-vs.md)
* [Restriction harmonized code value set](ValueSet-cz-restriction-harmonized-code-elp-vs.md)
* [Restriction national code value set](ValueSet-cz-restriction-national-code-elp-vs.md)
* [Restriction type value set](ValueSet-cz-restriction-type-elp-vs.md)
* [Vehicle value set](ValueSet-cz-vehicle-elp-vs.md)

### Logicals

* [A - Electronic Medical Report](StructureDefinition-ElpCz.md)
* [A.1 - Document header](StructureDefinition-HeaderElpCz.md)
* [A - Elektronický lékařský posudek](StructureDefinition-LogElpCz.md)
* [A.1 - Hlavička dokumentu](StructureDefinition-LogHeaderElpCz.md)
* [A.2.1 - Lékařská prohlídka](StructureDefinition-LogMedicalExaminationCz.md)
* [A.2.2 - Lékařský posudek](StructureDefinition-LogMedicalReportCz.md)
* [A.2.3 - Výsledek posudku](StructureDefinition-LogResultCz.md)
* [A.2.1 - Medical Examination](StructureDefinition-MedicalExaminationCz.md)
* [A.2.2 - Medical Report](StructureDefinition-MedicalReportCz.md)
* [A.2.3 - Result of the medical report](StructureDefinition-ResultCz.md)

### Resource Profiles

* [Appointment (ELP CZ)](StructureDefinition-cz-appointment-elp.md)
* [Bundle (ELP CZ)](StructureDefinition-cz-bundle-elp.md)
* [Composition (ELP CZ)](StructureDefinition-cz-composition-elp.md)
* [Diagnostic Report (ELP CZ)](StructureDefinition-cz-diagnostic-report-elp.md)
* [Observation of medical examination (ELP CZ)](StructureDefinition-cz-observation-examination-elp.md)
* [Observation of medical report (ELP CZ)](StructureDefinition-cz-observation-result-elp.md)

### ConceptMaps

* [CZ Header Model to this guide Map](ConceptMap-Header2FHIR-cz.md)
* [CZ Medical Examination Model to this guide Map](ConceptMap-MedicalExamination2FHIR-cz.md)
* [CZ Medical Report Model to this guide Map](ConceptMap-MedicalReport2FHIR-cz.md)
* [CZ Result Model to this guide Map](ConceptMap-Result2FHIR-cz.md)

### ImplementationGuides

* [HL7 Czech Electronic medical report Implementation Guide](index.md)

### Examples

* [064c136d-0d08-4b8f-bd76-8d79de3ee99e (Appointment)](Appointment-064c136d-0d08-4b8f-bd76-8d79de3ee99e.md)
* [cz-example-bundle-electronicmedicalreport (Bundle)](Bundle-cz-example-bundle-electronicmedicalreport.md)
* [Electronic Medical Report for patient Mracena (Composition)](Composition-543ea990-357a-4514-94d2-e33202cec664.md)
* [03b0d597-d68d-4966-9400-7752bb3ee39d (DiagnosticReport)](DiagnosticReport-03b0d597-d68d-4966-9400-7752bb3ee39d.md)
* [fea7c433-3f5b-477e-b70b-9db90bad8958 (DocumentReference)](DocumentReference-fea7c433-3f5b-477e-b70b-9db90bad8958.md)
* [777f4db4-4a50-4f89-8bc6-287a59973807 (Observation)](Observation-777f4db4-4a50-4f89-8bc6-287a59973807.md)
* [9994fdeb-dc0c-43aa-a998-6f02e7b88d32 (Observation)](Observation-9994fdeb-dc0c-43aa-a998-6f02e7b88d32.md)
* [Fakultní nemocnice Oblackov (Organization)](Organization-70df1d8e-4b6b-45ac-a5bf-719960e948bf.md)
* [2f4dde8e-ad7d-432d-aa49-e995367bbfc3 (Patient)](Patient-2f4dde8e-ad7d-432d-aa49-e995367bbfc3.md)
* [22d17422-a509-46c6-b5b6-f29f19dc788e (Practitioner)](Practitioner-22d17422-a509-46c6-b5b6-f29f19dc788e.md)
* [a9c01336-79c9-4e4f-a5c4-5ae9185cef19 (PractitionerRole)](PractitionerRole-a9c01336-79c9-4e4f-a5c4-5ae9185cef19.md)
