# Home - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/ImplementationGuide/hl7.fhir.cz.elp | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:HL7CzELPImplementationGuide |

## Introduction

This implementation specification is based on the [FHIR version R4](https://hl7.org/fhir/R4/), and defines a unified framework for representing the Electronic medical report in the Czech national context. The specification defines the content and structural components of the document and ensures their compliance with the legal requirements of the Czech Republic as well as with European initiatives in the field of electronic health record interoperability.

The main objective is to create a standardized form of the Electronic medical report as part of the patient’s medical documentation, which will be used for the electronic exchange of health information between healthcare providers, the patient, and the national infrastructure.

### Scope

his guide is divided into several pages, which are listed in the menu bar at the top of each page.

* [Home](index.md): This page provides introductory information, a brief scope of use, references, dependencies, version difference analysis, and intellectual property statements.
* Introduction: 
* [Scope and Content](scope-and-content.md): This section contains introductory general information about the Electronic medical reports.
* [Background](background.md): This section provides general information on the origins of the definition of the Electronic medical reports.
 
* Functional: 
* [Use Cases](use-cases.md): This section contains information about use cases.
* [Workflow](workflow.md): This segment contains information about workflow.
* [Logical Models](logical-models.md): This section contains information about logical models.
 
* Implementation: 
* [Mapping to profiles](model-map.md): This section contains information on mapping the logical model to the Electronic medical report profiles.
* [Examples](examples.md): This section contains examples.
 
* About: 
* [Authors](authors.md): This section contains information about the authors.
* [Downloads](downloads.md): This section provides information about available downloads of the implementation specification.
* [Dependencies](dependencies.md): This section provides information about dependencies.
* [Copyright](copyright.md): This section provides information about copyright.
 
* [Artifacts](artifacts.md): This page provides a list of FHIR artifacts defined as part of this implementation guide.

### References

* Related specifications: 
* [EHDS Logical Information Models](http://build.fhir.org/ig/Xt-EHR/xt-ehr-common/index.html) 
* This specification has inspired many of the design patterns defined in this IG.
 
* [HL7 Czech Base and Core Implementation Guide](http://build.fhir.org/ig/HL7-cz/cz-core/index.html) 
* Where possible this specification has been aligned with choices made in CZ core.
 
 

### Dependencies









### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cz.elp.r4)](package.r4.tgz) and [R4B (hl7.fhir.cz.elp.r4b)](package.r4b.tgz) are available.

### IP statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.3.0/CodeSystem-ISO3166Part1.html): [Bundle/cz-example-bundle-electronicmedicalreport](Bundle-cz-example-bundle-electronicmedicalreport.md), [CZ_AppointmentElp](StructureDefinition-cz-appointment-elp.md)...Show 35 more,[CZ_AppointmentServiceCategoryELPVS](ValueSet-cz-appointment-service-category-elp-vs.md),[CZ_AppointmentServiceTypeELPVS](ValueSet-cz-appointment-service-type-elp-vs.md),[CZ_BundleElp](StructureDefinition-cz-bundle-elp.md),[CZ_CategoryByDriverELPVS](ValueSet-cz-category-by-driver-elp-vs.md),[CZ_CompositionElp](StructureDefinition-cz-composition-elp.md),[CZ_ConclusionCodeELPVS](ValueSet-cz-conclusion-code-elp-vs.md),[CZ_DiagnosticReportElp](StructureDefinition-cz-diagnostic-report-elp.md),[CZ_ObservationCodeAltELPVS](ValueSet-cz-observation-code-alt-elp-vs.md),[CZ_ObservationCodeELPVS](ValueSet-cz-observation-code-elp-vs.md),[CZ_ObservationExaminationElp](StructureDefinition-cz-observation-examination-elp.md),[CZ_ObservationResultElp](StructureDefinition-cz-observation-result-elp.md),[CZ_RestrictionClarificationELPCS](CodeSystem-cz-restriction-clarification-elp-cs.md),[CZ_RestrictionClarificationELPVS](ValueSet-cz-restriction-clarification-elp-vs.md),[CZ_RestrictionHarmonizedCodeELPVS](ValueSet-cz-restriction-harmonized-code-elp-vs.md),[CZ_RestrictionNationalCodeELPVS](ValueSet-cz-restriction-national-code-elp-vs.md),[CZ_RestrictionTypeELPCS](CodeSystem-cz-restriction-type-elp-cs.md),[CZ_RestrictionTypeELPVS](ValueSet-cz-restriction-type-elp-vs.md),[CZ_VehicleELPVS](ValueSet-cz-vehicle-elp-vs.md),[ElpRo100](CodeSystem-elp-ro--1.0.0.md),[HL7CzELPImplementationGuide](index.md),[Header2FHIR](ConceptMap-Header2FHIR-cz.md),[LogCzElpCz](StructureDefinition-LogElpCz.md),[LogCzHeaderElpCz](StructureDefinition-LogHeaderElpCz.md),[LogCzMedicalExaminationCz](StructureDefinition-LogMedicalExaminationCz.md),[LogCzMedicalReportCz](StructureDefinition-LogMedicalReportCz.md),[LogCzResultCz](StructureDefinition-LogResultCz.md),[LogEnElpCz](StructureDefinition-ElpCz.md),[LogEnHeaderElpCz](StructureDefinition-HeaderElpCz.md),[LogEnMedicalExaminationCz](StructureDefinition-MedicalExaminationCz.md),[LogEnMedicalReportCz](StructureDefinition-MedicalReportCz.md),[LogEnResultCz](StructureDefinition-ResultCz.md),[MedicalExamination2FHIR](ConceptMap-MedicalExamination2FHIR-cz.md),[MedicalReport2FHIR](ConceptMap-MedicalReport2FHIR-cz.md),[Patient/2f4dde8e-ad7d-432d-aa49-e995367bbfc3](Patient-2f4dde8e-ad7d-432d-aa49-e995367bbfc3.md)and[Result2FHIR](ConceptMap-Result2FHIR-cz.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.3.0/CodeSystem-v3-loinc.html): [Bundle/cz-example-bundle-electronicmedicalreport](Bundle-cz-example-bundle-electronicmedicalreport.md), [CZ_CompositionElp](StructureDefinition-cz-composition-elp.md), [Composition/543ea990-357a-4514-94d2-e33202cec664](Composition-543ea990-357a-4514-94d2-e33202cec664.md) and [DiagnosticReport/03b0d597-d68d-4966-9400-7752bb3ee39d](DiagnosticReport-03b0d597-d68d-4966-9400-7752bb3ee39d.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [Bundle/cz-example-bundle-electronicmedicalreport](Bundle-cz-example-bundle-electronicmedicalreport.md), [CZ_ObservationCodeAltELPVS](ValueSet-cz-observation-code-alt-elp-vs.md), [CZ_ObservationResultElp](StructureDefinition-cz-observation-result-elp.md), [Observation/9994fdeb-dc0c-43aa-a998-6f02e7b88d32](Observation-9994fdeb-dc0c-43aa-a998-6f02e7b88d32.md) and [PractitionerRole/a9c01336-79c9-4e4f-a5c4-5ae9185cef19](PractitionerRole-a9c01336-79c9-4e4f-a5c4-5ae9185cef19.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Observation Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-observation-category.html): [Bundle/cz-example-bundle-electronicmedicalreport](Bundle-cz-example-bundle-electronicmedicalreport.md), [Observation/777f4db4-4a50-4f89-8bc6-287a59973807](Observation-777f4db4-4a50-4f89-8bc6-287a59973807.md) and [Observation/9994fdeb-dc0c-43aa-a998-6f02e7b88d32](Observation-9994fdeb-dc0c-43aa-a998-6f02e7b88d32.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [Bundle/cz-example-bundle-electronicmedicalreport](Bundle-cz-example-bundle-electronicmedicalreport.md) and [Patient/2f4dde8e-ad7d-432d-aa49-e995367bbfc3](Patient-2f4dde8e-ad7d-432d-aa49-e995367bbfc3.md)


