# Background - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Background**

## Background

### General requirements

A medical report is a document containing a doctor's professional opinion on the health condition of the person being assessed. This document is used, for example, when assessing fitness for work, applying for social benefits, granting disability status, or assessing fitness to drive motor vehicles.

Currently, medical reports are mainly issued in paper form.

The issuance of medical reports in the Czech Republic is governed by several legal regulations that set out the conditions, processes, and obligations of doctors, employers, and other entities.

**The key laws and regulations are:**

* [Act No. 325/2021 Coll.](https://www.e-sbirka.cz/sb/2021/325/2025-01-01), on the digitization of healthcare (Act on the Digitization of Healthcare) 
* **Establishes** the infrastructure for electronic healthcare.
* **It regulates the principles** of electronic identification, security, and sharing of healthcare data.
* It allows **medical reports to be kept exclusively in electronic form** and made available to authorized entities.
 
* [Act No. 372/2011 Coll.](https://www.e-sbirka.cz/sb/2011/372/2025-01-01), on health services 
* **Supplements the rules** on the provision of health services, including the keeping of medical records containing the basis **for issuing assessments**.
 
* **The general requirements for current medical assessments** are set out in Part 5 of Annex No. 1 to [Decree No. 444/2024 Coll.](https://www.e-sbirka.cz/sb/2024/444/2025-01-01), on medical records.
* [Act No. 262/2006 Coll.](https://www.e-sbirka.cz/sb/2006/262/2025-06-01), Labor Code 
* **Work capacity** – regulates the requirements for medical fitness for work within the framework of labor relations.
* [Decree No. 79/2013 Coll.](https://www.e-sbirka.cz/sb/2013/79/2024-01-31), on occupational health services and certain types of assessment care 
* Regulates in detail the rules for occupational medical examinations and their documentation.
 
 
* [Decree No. 104/2012 Coll.](https://www.e-sbirka.cz/sb/2012/104/2012-04-01), on the assessment of occupational diseases 
* Specifies more detailed requirements for the procedure for assessing and recognizing occupational diseases and the group of persons to whom the medical assessment of occupational disease is submitted, the conditions under which the disease can no longer be recognized as an occupational disease, and the requirements for such a medical assessment.
 
* [Act No. 361/2000 Coll.](https://www.e-sbirka.cz/sb/2000/361/2025-07-01), on road traffic 
* **Driving ability** – concerns medical assessments for driving licenses.
* [Decree No. 277/2004 Coll.](https://www.e-sbirka.cz/sb/2004/277/2025-07-01), on determining medical fitness to drive motor vehicles 
* Sets out the conditions for medical fitness and procedures for issuing assessments for driving motor vehicles.
 
 
* [Act No. 119/2002 Coll.](https://www.e-sbirka.cz/sb/2002/119/2025-07-01), on firearms and ammunition (from January 1, 2026 [Act No. 90/2024 Coll.](https://www.e-sbirka.cz/sb/2024/90/2026-01-01))
* **Eligibility for a firearms license**. 
* [Decree No. 493/2002 Coll.](https://www.e-sbirka.cz/sb/2002/493/2007-12-01) (repealed on January 1, 2026 and replaced by [Act No. 90/2024 Coll.](https://www.e-sbirka.cz/sb/2024/90/2026-01-01)), on the assessment of medical fitness for the issuance or validity of a firearms license and on the contents of a first aid kit for shooting range operators
 
* Specifies the medical requirements for holding a firearms license.
* [Act No. 99/1963 Coll.](https://www.e-sbirka.cz/sb/1963/99/2025-10-01), the Code of Civil Procedure or [Act No. 141/1961 Coll.](https://www.e-sbirka.cz/sb/1961/141/2025-07-01), the Criminal Procedure Code, and other specific laws related to court proceedings. 
* **Medical reports for court proceedings** – for assessing health status for the purposes of guardianship, adoption, foster care, labor disputes, criminal proceedings, etc.
 
* [Act No. 89/2012 Coll.](https://www.e-sbirka.cz/sb/2012/89/2025-07-01), Civil Code 
* E.g. **assessments for insurance companies and compensation** – for assessing health status for the purposes of insurance benefits (accident or life insurance).
 
* [Act No. 108/2006 Coll.](https://www.e-sbirka.cz/sb/2006/108/2025-10-01), on social services 
* **Assessment of long-term adverse health condition** – for granting a care allowance or a disability card.
 
* [Act No. 258/2000 Coll.](https://www.e-sbirka.cz/sb/2000/258/2025-10-01), on the protection of public health 
* **Assessment of a child's medical fitness for a recreational event** (camp, school trip, etc.).
* [Decree No. 106/2001 Coll.](https://www.e-sbirka.cz/sb/2001/106/2014-01-01), on hygiene requirements for recreational events for children 
* Specifies the assessment of a child's medical fitness to participate in a recreational event and school trip.
 
 
* [Act No. 48/1997 Coll.](https://www.e-sbirka.cz/sb/1997/48/2025-10-01), on public health insurance 
* **Assessments for spa treatment**.
 

-------

### Medical assessment for driving motor vehicles

#### Sample medical assessment

**Fig. 1: Paper form**

#### Life situations related to medical assessment

##### Medical fitness for applying for a driving license and its issuance (including driving license extension) – NON-DIGITALIZED PROCESS

Ensuring the assessment of the medical fitness of applicants for a driving license before starting lessons and training at a driving school. This situation applies when an applicant submits an application for a driver's license and must prove that they are medically fit to drive a motor vehicle (Section 82(1)(b), Section 84(2) of the Road Traffic Act, Section 13(1)(d) and (4) [Act No. 247/2000 Coll.)](https://www.e-sbirka.cz/sb/2000/247/2025-07-01)).

**Data recipients:**

* Ministry of Transport of the Czech Republic via the Shared Services Information System.
* Municipalities with extended powers (ORP)/Driving schools (for validation of applicants' medical fitness) via the Ministry of Transport of the Czech Republic – Central Register of Drivers (CRŘ).

**Data to be used:**

* Medical assessment (XML structure).

**Processes:**

* Data transfer: Medical examination and issuance of an assessment, followed by storage of the assessment in the Ministry of Health of the Czech Republic system.
* Decision: Based on the validation of medical fitness, the applicant will be allowed to continue with instruction and training if they are fit, or a driving license will be issued.
* Data acquisition: The Ministry of Transport of the Czech Republic downloads data on the driver's medical assessment and stores it in its system for possible provision to the Municipalities with extended powers (ORP) or the Police of the Czech Republic.

**Fig. 2: Diagram of the life situation**

-------

##### Roadside checks of senior citizens - Regular medical examinations for drivers over 70 years of age

Regular assessment of medical fitness for drivers over 70 years of age who are required to undergo regular medical examinations in order to continue driving motor vehicles.

**Data recipients:**

* Ministry of Transport of the Czech Republic via the Shared Services Information System.
* Police of the Czech Republic via the Ministry of Transport of the Czech Republic - Central Register of Drivers (to verify that the driver has a current medical assessment).

**Data to be used:**

* Medical assessment (XML structure for updating medical fitness). In the event of an update, a new/updated medical assessment will be uploaded.
* Date of validity of the assessment.

**Processes:**

* Data transfer: The doctor issues a new assessment, which will be a record for continuing to drive a motor vehicle – stored in the Ministry of Health of the Czech Republic system.
* Validation: The Ministry of Transport checks the validity/validity of the assessment (it inquires whether there is a valid assessment in the Ministry of Health system via the Shared Services Information System) and enters it into the Central Register of Drivers (CRŘ). The Czech Police inquires online with the CRŘ during road checks.
* Decision: Based on the validation of medical fitness, the Czech Police assesses the situation.

**Fig. 3: Diagram of the life situation**

> Note: This process can also be applied in the case of regular medical examinations, which drivers are required to undergo pursuant to Section 87(1) of the Road Traffic Act.

-------

##### Medical fitness for specific groups of drivers (e.g., persons with disabilities or limited mobility)

Assessment of medical fitness for drivers who have specific conditions for driving, e.g., disabilities or limited mobility, which require specific modifications for driving a motor vehicle.

**Data recipients:**

* Ministry of Transport of the Czech Republic via the Shared Services Information System.
* Driving schools (for accepting applicants with special needs) via the Ministry of Transport of the Czech Republic – Central Register of Drivers (CRŘ).
* Municipalities with extended powers (ORP)/Czech Police (for checking eligibility) via the Ministry of Transport of the Czech Republic - CRŘ.

**Data to be used:**

* Medical assessment (XML for structured information on health restrictions).
* Specification of health restrictions or vehicle requirements (e.g., wheelchair adaptation).

**Processes:**

* Data transfer: The doctor issues an assessment with specific conditions for driving.
* Decision on vehicle adaptation: The Ministry of Transport of the Czech Republic and the driving school process the data and ensure that the applicant will be able to drive a vehicle adapted to their health condition.
* Validation: The Czech Ministry of Transport checks the validity of the assessment (it inquires whether there is a valid assessment in the Czech Ministry of Health's system via the Shared Services Information System) and transfers the data to the Czech Police.

**Fig. 4: Diagram of the life situation**

-------

##### Situation: Change in medical fitness

Notification of a change in the medical fitness of the patient in question – a driver – by means of an updated medical assessment.

**Data recipients:**

* Ministry of Transport of the Czech Republic via the Shared Services Information System.
* Municipalities with extended powers (ORP)/Czech Police (for eligibility checks) via the Ministry of Transport of the Czech Republic – Central Driver Register.

**Data to be used:**

* Updated medical assessment (XML for structured information on health restrictions).

**Processes:**

* Data transfer: The doctor issues an updated medical assessment. The Ministry of Health of the Czech Republic system sends a notification of the update of the medical assessment of the relevant patient – driver.
* Validation: Based on the notification, the Ministry of Transport downloads the updated assessment and enters it into the Central Register of Drivers.
* Decision: Based on the validation of medical fitness, the Municipalities with extended powers (ORP) assesses the situation.

**Fig. 5: Diagram of the life situation**

