# Background - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Background**

## Background

### Obecné náležitosti

Lékařský posudek je dokument, který obsahuje odborné stanovisko lékaře o zdravotním stavu posuzované osoby. Tento dokument se využívá například při posuzování pracovní způsobilosti, žádosti o sociální dávky, přiznání invalidity nebo zdravotní způsobilosti k řízení motorových vozidel.

V současnosti je forma vydávání lékařských posudků zejména v papírové – listinné podobě.

Vydávání lékařských posudků v České republice je upraveno několika právními předpisy, které stanovují podmínky, procesy a povinnosti lékařů, zaměstnavatelů a dalších subjektů.

**Klíčovými zákony a vyhláškami jsou:**

* [Zákon č. 325/2021 Sb.](https://www.e-sbirka.cz/sb/2021/325/2025-01-01), o elektronizaci zdravotnictví (zákon o elektronizaci zdravotnictví) 
* **Zakládá** infrastrukturu elektronického zdravotnictví.
* **Upravuje principy** elektronické identifikace, bezpečnosti a sdílení zdravotnických údajů.
* Umožňuje, aby **lékařské posudky byly vedeny výhradně elektronicky** a byly dostupné oprávněným subjektům.
 
* [Zákon č. 372/2011 Sb.](https://www.e-sbirka.cz/sb/2011/372/2025-01-01), o zdravotních službách 
* **Doplňuje pravidla** o poskytování zdravotních služeb včetně vedení zdravotnické dokumentace, která obsahuje podklady **pro vydání posudků**.
 
* **Obecné náležitosti současných lékařských posudků** jsou uvedeny v části 5 přílohy č. 1 k [vyhlášce č. 444/2024 Sb.](https://www.e-sbirka.cz/sb/2024/444/2025-01-01), o zdravotnické dokumentaci.
* [Zákon č. 262/2006 Sb.](https://www.e-sbirka.cz/sb/2006/262/2025-06-01), zákoník práce 
* **Pracovní způsobilost** – v rámci pracovněprávních vztahů upravuje požadavky na zdravotní způsobilost k práci.
* [Vyhláška č. 79/2013 Sb.](https://www.e-sbirka.cz/sb/2013/79/2024-01-31), o pracovnělékařských službách a některých druzích posudkové péče 
* Detailně upravuje pravidla pro pracovnělékařské prohlídky a jejich dokumentaci.
 
* [Vyhláška č. 104/2012 Sb.](https://www.e-sbirka.cz/sb/2012/104/2012-04-01), o posuzování nemocí z povolání 
* Specifikuje bližší požadavky na postup při posuzování a uznávání nemocí z povolání a okruh osob, kterým se předává lékařský posudek o nemoci z povolání, podmínky, za nichž nemoc nelze nadále uznat za nemoc z povolání, a náležitosti takového lékařského posudku.
 
 
* [Zákon č. 361/2000 Sb.](https://www.e-sbirka.cz/sb/2000/361/2025-07-01), o provozu na pozemních komunikacích 
* **Řidičská způsobilost** – týká se zdravotních posudků pro řidičská oprávnění.
* [Vyhláška č. 277/2004 Sb.](https://www.e-sbirka.cz/sb/2004/277/2025-07-01), o stanovení zdravotní způsobilosti k řízení motorových vozidel 
* Stanovuje podmínky zdravotní způsobilosti a postupy při vydávání posudků k řízení motorových vozidel.
 
 
* [Zákon č. 119/2002 Sb.](https://www.e-sbirka.cz/sb/2002/119/2025-07-01), o střelných zbraních a střelivu (od 1.1.2026 [Zákon č. 90/2024 Sb.](https://www.e-sbirka.cz/sb/2024/90/2026-01-01)) 
* **Způsobilost pro držení zbrojního průkazu**.
* [Vyhláška č. 493/2002 Sb.](https://www.e-sbirka.cz/sb/2002/493/2007-12-01) (zrušeno 1.1.2026 a nahrazuje znění [Zákon č. 90/2024 Sb.](https://www.e-sbirka.cz/sb/2024/90/2026-01-01)), o posuzování zdravotní způsobilosti k vydání nebo platnosti zbrojního průkazu a o obsahu lékárničky první pomoci provozovatele střelnice 
* Specifikuje zdravotní požadavky pro držení zbrojního průkazu.
 
 
* [Zákon č. 99/1963 Sb.](https://www.e-sbirka.cz/sb/1963/99/2025-10-01), občanský soudní řád nebo [zákon č. 141/1961 Sb.](https://www.e-sbirka.cz/sb/1961/141/2025-07-01), trestní řád, a další specifické zákony související se soudním řízením. 
* **Lékařské posudky pro soudní řízení** – pro posouzení zdravotního stavu pro účely opatrovnictví, adopci, pěstounskou péči, pracovních sporů, trestního řízení apod.
 
* [Zákon č. 89/2012 Sb.](https://www.e-sbirka.cz/sb/2012/89/2025-07-01), občanský zákoník 
* Např. **posudky pro pojišťovny a odškodnění** – pro posouzení zdravotního stavu pro účely pojistného plnění (úrazové nebo životní pojištění).
 
* [Zákon č. 108/2006 Sb.](https://www.e-sbirka.cz/sb/2006/108/2025-10-01), o sociálních službách 
* **Posouzení dlouhodobě nepříznivého zdravotního stavu** – pro přiznání příspěvku na péči nebo průkazu osoby se zdravotním postižením.
 
* [Zákon č. 258/2000 Sb.](https://www.e-sbirka.cz/sb/2000/258/2025-10-01), o ochraně veřejného zdraví 
* **Posudek o zdravotní způsobilosti dítěte na zotavovací akci** (tábor, škola v přírodě apod.).
* [Vyhláška č. 106/2001 Sb.](https://www.e-sbirka.cz/sb/2001/106/2014-01-01), o hygienických požadavcích na zotavovací akce pro děti 
* Specifikuje posudek o zdravotní způsobilosti dítěte k účasti na zotavovací akci a škole v přírodě.
 
 
* [Zákon č. 48/1997 Sb.](https://www.e-sbirka.cz/sb/1997/48/2025-10-01), o veřejném zdravotním pojištění 
* **Posudky pro lázeňskou léčbu**.
 

-------

### Lékařský posudek k řízení motorových vozidel

#### Vzor lékařského posudku

**Obr. 1: Listinná podoba**

#### Životní situace související s lékařským posudkem

##### Zdravotní způsobilost pro žádost o ŘO a jeho vystavení (včetně rozšíření ŘO) – NEDIGITALIZOVANÝ PROCES

Zajištění posouzení zdravotní způsobilosti žadatelů o Řidičského oprávnění (ŘO) před zahájením výuky a výcviku v autoškole. Tato situace se aplikuje v okamžiku, kdy žadatel podává žádost o vydání ŘO a musí doložit, že je zdravotně způsobilý k řízení motorového vozidla (§ 82 odst. 1 písm. b), § 84 odst. 2 zákona o silničním provozu, § 13 odst. 1 písm. d) a odst. 4 [zákona č. 247/2000 Sb.)](https://www.e-sbirka.cz/sb/2000/247/2025-07-01)).

**Příjemce dat:**

* Ministerstvo dopravy ČR prostřednictvím Informačního systému sdílené služby .
* ORP/Autoškoly (pro validaci zdravotní způsobilosti žadatelů) prostřednictvím Ministerstva dopravy ČR – Centrální registr řidičů (CRŘ).

**Data, která budou použita:**

* Lékařský posudek (XML struktura).

**Procesy:**

* Předávání dat: Lékařská prohlídka a vystavení posudku, následně uložení posudku do systému MZ ČR.
* Rozhodnutí: Na základě validace zdravotní způsobilosti bude žadateli umožněno pokračovat ve výuce a výcviku, pokud je způsobilý, příp. bude vydáno ŘO.
* Získání dat: Ministerstvo dopravy ČR stahuje data o lékařském posudku řidiče a ukládá do svého systému pro možné poskytnutí ORP nebo Policii ČR.

**Obr. 2: Schéma životní situace**

-------

##### Silniční kontrola seniorů - Pravidelná lékařská prohlídka řidičů nad 70 let

Pravidelné posouzení zdravotní způsobilosti pro řidiče ve věku nad 70 let, kteří jsou povinni podstupovat pravidelné lékařské prohlídky, aby mohli pokračovat v řízení motorových vozidel.

**Příjemce dat:**

* Ministerstvo dopravy ČR prostřednictvím Informačního systému sdílené služby .
* Policie ČR prostřednictvím Ministerstva dopravy ČR - Centrální registr řidičů (pro ověření, zda má řidič aktuální zdravotní posudek).

**Data, která budou použita:**

* Lékařský posudek (XML struktura pro aktualizaci zdravotní způsobilosti). V případě aktualizace dojde k nahrání nového/aktualizovaného lékařského posudku.
* Datum platnosti posudku.

**Procesy:**

* Předávání dat: Lékař vystaví nový posudek, který bude záznamem pro pokračování v řízení motorového vozidla – uložení do systému MZ ČR.
* Validace: MD kontroluje aktuálnost/platnost posudku (doptá se, zda existuje platný posudek v systému MZ ČR přes Informační systém sdílené služby) a vkládá do Centrálního registru řidičů (CRŘ). Policie ČR se při silniční kontrole doptává online do CRŘ.
* Rozhodnutí: Na základě validace zdravotní způsobilosti Policie ČR zhodnotí situaci.

**Obr. 3: Schéma životní situace**

> Pozn.: Tento proces lze aplikovat i v případě pravidelných lékařských prohlídek, které jsou povinny absolvovat řidiči dle § 87 odst. 1 zákona o silničním provozu.

-------

##### Zdravotní způsobilost pro specifické skupiny řidičů (např. osoby s postižením nebo omezenou pohyblivostí)

Posouzení zdravotní způsobilosti pro řidiče, kteří mají specifické podmínky pro řízení, např. postižení nebo omezenou pohyblivost, což vyžaduje specifické úpravy pro řízení motorového vozidla.

**Příjemce dat:**

* Ministerstvo dopravy ČR prostřednictvím Informačního systému sdílené služby .
* Autoškoly (pro přijímání žadatelů se speciálními potřebami) prostřednictvím Ministerstva dopravy ČR – Centrální registr řidičů (CRŘ).
* ORP/Policie ČR (pro kontrolu způsobilosti) prostřednictvím Ministerstva dopravy ČR - CRŘ.

**Data, která budou použita:**

* Lékařský posudek (XML pro strukturované informace o zdravotních omezeních).
* Specifikace zdravotních omezení, příp. požadavky na vozidlo (např. adaptace pro invalidní vozík).

**Procesy:**

* Předávání dat: Lékař vystaví posudek se specifickými podmínkami pro řízení.
* Rozhodnutí o přizpůsobení vozidla: Ministerstvo dopravy ČR a autoškola zpracují data a zajistí, že žadatel bude moci řídit vozidlo přizpůsobené jeho zdravotnímu stavu.
* Validace: Ministerstvo dopravy ČR kontroluje aktuálnost/platnost posudku (doptá se, zda existuje platný posudek v systému Ministerstva zdravotnictví ČR přes Informační systém sdílené služby) a předává data Policii ČR.

**Obr. 4: Schéma životní situace**

-------

##### Situace: Změna zdravotní způsobilost

Informování o změně zdravotní způsobilosti příslušného pacienta – řidiče, a to prostřednictvím aktualizovaného lékařského posudku.

**Příjemce dat:**

* Ministerstvo dopravy ČR prostřednictvím Informačního systému sdílené služby .
* ORP/Policie ČR (pro kontrolu způsobilosti) prostřednictvím Ministerstva dopravy ČR - Centrální registr řidičů.

**Data, která budou použita:**

* Aktualizovaný lékařský posudek (XML pro strukturované informace o zdravotních omezeních).

**Procesy:**

* Předávání dat: Lékař vystaví aktualizovaný lékařský posudek. Systém MZ ČR zašle notifikaci o aktualizaci lékařského posudku příslušného pacienta – řidiče.
* Validace: MD stahuje na základě notifikace aktualizovaný posudek a vkládá do Centrálního registru řidičů.
* Rozhodnutí: Na základě validace zdravotní způsobilosti ORP zhodnotí situaci.

**Obr. 5: Schéma životní situace**

