# Artifacts - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Artifacts**

## Artifacts

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Czech logical model (Informative) 

Logical model in czech language. Informative for this version of the guide.

| | |
| :--- | :--- |
| [A - Elektronický lékařský posudek](StructureDefinition-LogElpCz.md) | Logický model Elektronického lékařského posudku podle české specifikace |
| [A.1 - Hlavička dokumentu](StructureDefinition-LogHeaderElpCz.md) | Hlavička elektronického lékařského posudku podle české specifikace. |
| [A.2.1 - Lékařská prohlídka](StructureDefinition-LogMedicalExaminationCz.md) | Zjištění o zdravotním stavu posuzované osoby a komplexní fyzikální vyšetření |
| [A.2.2 - Lékařský posudek](StructureDefinition-LogMedicalReportCz.md) | Posudek musí být jednoznačný a nesmí obsahovat diagnózu nemoci |
| [A.2.3 - Výsledek posudku](StructureDefinition-LogResultCz.md) | Výsledek posudku o zdravotní způsobilosti k řízení motorových vozidel |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [A - Electronic Medical Report](StructureDefinition-ElpCz.md) | Logical model of Electronic Medical Report according to Czech specifications |
| [A.1 - Document header](StructureDefinition-HeaderElpCz.md) | Header of the electronic medical report according to Czech specifications. |
| [A.2.1 - Medical Examination](StructureDefinition-MedicalExaminationCz.md) | Findings on the health status of the person being examined and comprehensive physical examination |
| [A.2.2 - Medical Report](StructureDefinition-MedicalReportCz.md) | The report must be unambiguous and must not contain a diagnosis of illness |
| [A.2.3 - Result of the medical report](StructureDefinition-ResultCz.md) | Result of the report on medical ability to drive motor vehicles |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Appointment (ELP CZ)](StructureDefinition-cz-appointment-elp.md) | Appointment used to represent a medical examination for the scope of this guide. |
| [Bundle (ELP CZ)](StructureDefinition-cz-bundle-elp.md) | Clinical document used to represent a Electronic Medical Report for the scope of this guide. |
| [Composition (ELP CZ)](StructureDefinition-cz-composition-elp.md) | This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide. |
| [Diagnostic Report (ELP CZ)](StructureDefinition-cz-diagnostic-report-elp.md) | Diagnostic Report used to represent a medical report for the scope of this guide. |
| [Observation of medical examination (ELP CZ)](StructureDefinition-cz-observation-examination-elp.md) | Appointment used to represent an observation of medical examination for the scope of this guide. |
| [Observation of medical report (ELP CZ)](StructureDefinition-cz-observation-result-elp.md) | Appointment used to represent an observation of medical report for the scope of this guide. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Alternative Observation Code for ELP valueset](ValueSet-cz-observation-code-alt-elp-vs.md) | Alternative Observation Code for ELP valueset |
| [Appointment service category value set](ValueSet-cz-appointment-service-category-elp-vs.md) | Appointment service category value set |
| [Appointment service type value set](ValueSet-cz-appointment-service-type-elp-vs.md) | Appointment service type value set |
| [Category by driver value set](ValueSet-cz-category-by-driver-elp-vs.md) | Category by driver value set |
| [Conclusion code value set](ValueSet-cz-conclusion-code-elp-vs.md) | Conclusion code value set |
| [Observation Code for ELP valueset](ValueSet-cz-observation-code-elp-vs.md) | Observation Code for ELP valueset |
| [Restriction clarification value set](ValueSet-cz-restriction-clarification-elp-vs.md) | Restriction clarification value set |
| [Restriction harmonized code value set](ValueSet-cz-restriction-harmonized-code-elp-vs.md) | Restriction harmonized code value set |
| [Restriction national code value set](ValueSet-cz-restriction-national-code-elp-vs.md) | Restriction national code value set |
| [Restriction type value set](ValueSet-cz-restriction-type-elp-vs.md) | Restriction type value set |
| [Vehicle value set](ValueSet-cz-vehicle-elp-vs.md) | Vehicle value set |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Electronic medical report CodeSystem](CodeSystem-elp-ro--1.0.0.md) | Code system used in the agenda of electronic medical report for driving licenses |
| [Restriction clarification code system](CodeSystem-cz-restriction-clarification-elp-cs.md) | Restriction clarification code system |
| [Restriction type code system](CodeSystem-cz-restriction-type-elp-cs.md) | Restriction type code system |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [CZ Header Model to this guide Map](ConceptMap-Header2FHIR-cz.md) | CZ Electronic Medical Report Header Model to this guide mapping |
| [CZ Medical Examination Model to this guide Map](ConceptMap-MedicalExamination2FHIR-cz.md) | CZ Electronic Medical Report Header Model to this guide mapping |
| [CZ Medical Report Model to this guide Map](ConceptMap-MedicalReport2FHIR-cz.md) | CZ Electronic Medical Report Header Model to this guide mapping |
| [CZ Result Model to this guide Map](ConceptMap-Result2FHIR-cz.md) | CZ Electronic Result Header Model to this guide mapping |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Appointment: ELP](Appointment-064c136d-0d08-4b8f-bd76-8d79de3ee99e.md) | Example of appointment for ELP record. |
| [Bundle: Electronic Medical Report (CZ)](Bundle-cz-example-bundle-electronicmedicalreport.md) | Example of Electronic Medical Report Bundle. |
| [Composition: Electronic Medical Report (CZ)](Composition-543ea990-357a-4514-94d2-e33202cec664.md) | Composition example for Electronic Medical Report. |
| [Diagnostic report: ELP](DiagnosticReport-03b0d597-d68d-4966-9400-7752bb3ee39d.md) | Example of diagnostic report for ELP record. |
| [Logo: Oblačkov](DocumentReference-fea7c433-3f5b-477e-b70b-9db90bad8958.md) | Example of logo as document reference for FN Obláčkov. |
| [Observation: Examination in ELP](Observation-777f4db4-4a50-4f89-8bc6-287a59973807.md) | Example of examination for ELP record. |
| [Observation: Result in ELP](Observation-9994fdeb-dc0c-43aa-a998-6f02e7b88d32.md) | Example of result for ELP record. |
| [Organization: FN Oblačkov](Organization-70df1d8e-4b6b-45ac-a5bf-719960e948bf.md) | An example of the organization with logo extension |
| [Patient Mracena](Patient-2f4dde8e-ad7d-432d-aa49-e995367bbfc3.md) | Patient Mracena with contact information and practitioner |
| [Practitioner: Testovací](Practitioner-22d17422-a509-46c6-b5b6-f29f19dc788e.md) | Author of ELP report |
| [PractitionerRole: Testovací](PractitionerRole-a9c01336-79c9-4e4f-a5c4-5ae9185cef19.md) | Author of ELP report |

