# Vehicle value set - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Vehicle value set**

## ValueSet: Vehicle value set 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-seznam-skupin | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_VehicleELPVS |

 
Vehicle value set 

 **References** 

* [Observation of medical report (ELP CZ)](StructureDefinition-cz-observation-result-elp.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-vehicle-elp-vs",
  "url" : "https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-seznam-skupin",
  "version" : "0.0.1",
  "name" : "CZ_VehicleELPVS",
  "title" : "Vehicle value set",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Vehicle value set",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/elp-ro",
        "concept" : [
          {
            "code" : "A",
            "display" : "A"
          },
          {
            "code" : "A1",
            "display" : "A1"
          },
          {
            "code" : "A2",
            "display" : "A2"
          },
          {
            "code" : "AM",
            "display" : "AM"
          },
          {
            "code" : "B",
            "display" : "B"
          },
          {
            "code" : "B1",
            "display" : "B1"
          },
          {
            "code" : "BE",
            "display" : "BE"
          },
          {
            "code" : "C",
            "display" : "C"
          },
          {
            "code" : "C1",
            "display" : "C1"
          },
          {
            "code" : "C1E",
            "display" : "C1E"
          },
          {
            "code" : "CE",
            "display" : "CE"
          },
          {
            "code" : "D",
            "display" : "D"
          },
          {
            "code" : "D1",
            "display" : "D1"
          },
          {
            "code" : "D1E",
            "display" : "D1E"
          },
          {
            "code" : "DE",
            "display" : "DE"
          },
          {
            "code" : "T",
            "display" : "T"
          }
        ]
      }
    ]
  }
}

```
