# Observation Code for ELP valueset - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation Code for ELP valueset**

## ValueSet: Observation Code for ELP valueset 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-odbornost | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_ObservationCodeELPVS |

 
Observation Code for ELP valueset 

 **References** 

* [Observation of medical examination (ELP CZ)](StructureDefinition-cz-observation-examination-elp.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-observation-code-elp-vs",
  "url" : "https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-odbornost",
  "version" : "0.0.1",
  "name" : "CZ_ObservationCodeELPVS",
  "title" : "Observation Code for ELP valueset",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Observation Code for ELP valueset",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/elp-ro",
        "concept" : [
          {
            "code" : "odbornost_lekare_ro_1",
            "display" : "všeobecné praktické lékařství"
          },
          {
            "code" : "odbornost_lekare_ro_2",
            "display" : "odborné lékařství"
          }
        ]
      }
    ]
  }
}

```
