# Diagnostic Report (ELP CZ) - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Diagnostic Report (ELP CZ)**

## Resource Profile: Diagnostic Report (ELP CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/cz-diagnostic-report-elp | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_DiagnosticReportElp |

 
Diagnostic Report used to represent a medical report for the scope of this guide. 

**Usages:**

* Use this Profile: [Bundle (ELP CZ)](StructureDefinition-cz-bundle-elp.md)
* Refer to this Profile: [Composition (ELP CZ)](StructureDefinition-cz-composition-elp.md)
* Examples for this Profile: [DiagnosticReport/03b0d597-d68d-4966-9400-7752bb3ee39d](DiagnosticReport-03b0d597-d68d-4966-9400-7752bb3ee39d.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/cz-diagnostic-report-elp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-diagnostic-report-elp.csv), [Excel](StructureDefinition-cz-diagnostic-report-elp.xlsx), [Schematron](StructureDefinition-cz-diagnostic-report-elp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-diagnostic-report-elp",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-diagnostic-report-elp",
  "version" : "0.0.1",
  "name" : "CZ_DiagnosticReportElp",
  "title" : "Diagnostic Report (ELP CZ)",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Diagnostic Report used to represent a medical report for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DiagnosticReport",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DiagnosticReport.category",
        "path" : "DiagnosticReport.category",
        "min" : 1
      },
      {
        "id" : "DiagnosticReport.category.coding",
        "path" : "DiagnosticReport.category.coding",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-druh-posudku"
        }
      },
      {
        "id" : "DiagnosticReport.effective[x]",
        "path" : "DiagnosticReport.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "DiagnosticReport.effective[x]:effectiveDateTime",
        "path" : "DiagnosticReport.effective[x]",
        "sliceName" : "effectiveDateTime",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DiagnosticReport.issued",
        "path" : "DiagnosticReport.issued",
        "min" : 1
      },
      {
        "id" : "DiagnosticReport.result",
        "path" : "DiagnosticReport.result",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/elp/StructureDefinition/cz-observation-result-elp"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.conclusionCode",
        "path" : "DiagnosticReport.conclusionCode",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-vysledek-posudku"
        }
      }
    ]
  }
}

```
