# Composition (ELP CZ) - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Composition (ELP CZ)**

## Resource Profile: Composition (ELP CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/cz-composition-elp | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_CompositionElp |

 
This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide. 

**Usages:**

* Use this Profile: [Bundle (ELP CZ)](StructureDefinition-cz-bundle-elp.md)
* Examples for this Profile: [Composition/543ea990-357a-4514-94d2-e33202cec664](Composition-543ea990-357a-4514-94d2-e33202cec664.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/cz-composition-elp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-composition-elp.csv), [Excel](StructureDefinition-cz-composition-elp.xlsx), [Schematron](StructureDefinition-cz-composition-elp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-composition-elp",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-composition-elp",
  "version" : "0.0.1",
  "name" : "CZ_CompositionElp",
  "title" : "Composition (ELP CZ)",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition",
        "short" : "Electronic Medical Report composition",
        "definition" : "Electronic Medical Report composition. \r\nA composition is a set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. \r\nWhile a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.",
        "constraint" : [
          {
            "key" : "text-or-section",
            "severity" : "error",
            "human" : "A Composition SHALL have either text, at least one section, or both.",
            "expression" : "text.exists() or section.exists()",
            "source" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-composition-elp"
          }
        ]
      },
      {
        "id" : "Composition.language",
        "path" : "Composition.language",
        "min" : 1
      },
      {
        "id" : "Composition.extension",
        "path" : "Composition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.extension:versionNumber",
        "path" : "Composition.extension",
        "sliceName" : "versionNumber",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Composition.version"
            ]
          }
        ]
      },
      {
        "id" : "Composition.extension:versionNumber.value[x]",
        "path" : "Composition.extension.value[x]",
        "short" : "Business version"
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "ELP business identifier"
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "short" : "ELP status"
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "104990-7",
              "display" : "Driver license medical fitness certificate"
            }
          ]
        }
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "definition" : "Who or what the composition is about. \r\nIn general a composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).\r\nFor the hdr the subject is always the patient.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "short" : "ELP date"
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "Who and/or what authored the Electronic Medical Report",
        "definition" : "Identifies who is responsible for the information in the Electronic Medical Report.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.title",
        "path" : "Composition.title",
        "short" : "Electronic Medical Report",
        "definition" : "Official human-readable label for the composition.\r\n\r\nFor this document should be \"Electronic Medical Report\" or any equivalent translation"
      },
      {
        "id" : "Composition.confidentiality",
        "path" : "Composition.confidentiality",
        "min" : 1
      },
      {
        "id" : "Composition.custodian",
        "path" : "Composition.custodian",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Sections of the report",
        "min" : 2
      },
      {
        "id" : "Composition.section.author",
        "path" : "Composition.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:medicalExamination",
        "path" : "Composition.section",
        "sliceName" : "medicalExamination",
        "short" : "Medical Examination Section",
        "definition" : "This section holds information about medical examinations and other specialist examinations of patients.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Composition.section:medicalExamination.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "56446-8"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:medicalExamination.entry",
        "path" : "Composition.section.entry",
        "short" : "Medical Examination",
        "definition" : "This entry holds information about medical examination (appointment) that is associated with this Composition.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/elp/StructureDefinition/cz-appointment-elp",
              "https://hl7.cz/fhir/elp/StructureDefinition/cz-observation-examination-elp"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:medicalReport",
        "path" : "Composition.section",
        "sliceName" : "medicalReport",
        "short" : "Medical Report Section",
        "definition" : "This section holds information about medical report.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Composition.section:medicalReport.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "104988-1"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:medicalReport.entry",
        "path" : "Composition.section.entry",
        "short" : "Medical Report",
        "definition" : "This entry holds a reference to the diagnostic report that is associated with this Composition.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/elp/StructureDefinition/cz-diagnostic-report-elp"
            ]
          }
        ]
      }
    ]
  }
}

```
