# A.2.3 - Result of the medical report - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.3 - Result of the medical report**

## Logical Model: A.2.3 - Result of the medical report 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/ResultCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnResultCz |

 
Result of the report on medical ability to drive motor vehicles 

**Usages:**

* Use this Logical Model: [A - Electronic Medical Report](StructureDefinition-ElpCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/ResultCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ResultCz.csv), [Excel](StructureDefinition-ResultCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ResultCz",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/ResultCz",
  "version" : "0.0.1",
  "name" : "LogEnResultCz",
  "title" : "A.2.3 - Result of the medical report",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Result of the report on medical ability to drive motor vehicles",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/elp/StructureDefinition/ResultCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ResultCz",
        "path" : "ResultCz",
        "short" : "A.2.3 - Result of the medical report",
        "definition" : "Result of the report on medical ability to drive motor vehicles"
      },
      {
        "id" : "ResultCz.medicalfitness",
        "path" : "ResultCz.medicalfitness",
        "short" : "A.2.3.1 - Medical fitness",
        "definition" : "A value from the AssessmentResultCodeList that indicates whether the person being assessed is medically fit to drive motor vehicles.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ResultCz.restrictionsHarmonizedCodes",
        "path" : "ResultCz.restrictionsHarmonizedCodes",
        "short" : "A.2.3.2 - Restrictions/conditions for driving a motor vehicle - harmonized codes",
        "definition" : "Restrictions on medical fitness to drive motor vehicles according to the ListHarmonizedCodesRO code list.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ResultCz.restrictionsNationalCodes",
        "path" : "ResultCz.restrictionsNationalCodes",
        "short" : "A.2.3.3 - Restrictions/conditions for driving a motor vehicle – national codes",
        "definition" : "Restrictions on medical fitness to drive motor vehicles according to the ListNationalCodesRO code list.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ResultCz.specificationRestriction",
        "path" : "ResultCz.specificationRestriction",
        "short" : "A.2.3.4 - Specification of restrictions/conditions for driving a motor vehicle",
        "definition" : "These are letters for use in combination with harmonized codes 01 to 44 for further specification of restrictions according to the ListSpecificationRo code list.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ResultCz.justification",
        "path" : "ResultCz.justification",
        "short" : "A.2.3.5 - Justification for restriction or condition",
        "definition" : "Text description by the assessing physician of the restriction or condition for driving a motor vehicle.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
