# A.2.2 - Medical Report - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.2 - Medical Report**

## Logical Model: A.2.2 - Medical Report 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/MedicalReportCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnMedicalReportCz |

 
The report must be unambiguous and must not contain a diagnosis of illness 

**Usages:**

* Use this Logical Model: [A - Electronic Medical Report](StructureDefinition-ElpCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/MedicalReportCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicalReportCz.csv), [Excel](StructureDefinition-MedicalReportCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicalReportCz",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalReportCz",
  "version" : "0.0.1",
  "name" : "LogEnMedicalReportCz",
  "title" : "A.2.2 - Medical Report",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "The report must be unambiguous and must not contain a diagnosis of illness",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalReportCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "MedicalReportCz",
        "path" : "MedicalReportCz",
        "short" : "A.2.2 - Medical Report",
        "definition" : "The report must be unambiguous and must not contain a diagnosis of illness"
      },
      {
        "id" : "MedicalReportCz.typeOfAssessment",
        "path" : "MedicalReportCz.typeOfAssessment",
        "short" : "A.2.2.1 - Type of assessment",
        "definition" : "Type of assessment for a driving license according to the TypeOfAssessmentRO code list.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicalReportCz.drivingLicenseGroup",
        "path" : "MedicalReportCz.drivingLicenseGroup",
        "short" : "A.2.2.2 - Driving license group",
        "definition" : "A driving license entitles its holder to drive a motor vehicle classified in the group of vehicles for which the driving license was issued. The values are from the ListGroupRo code list.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicalReportCz.dateValidUntil",
        "path" : "MedicalReportCz.dateValidUntil",
        "short" : "A.2.2.3 - Date of validity of the assessment",
        "definition" : "Date of expiry of the medical assessment.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "MedicalReportCz.dateOfIssueOfAssessment",
        "path" : "MedicalReportCz.dateOfIssueOfAssessment",
        "short" : "A.2.2.4 - Date of issue of assessment",
        "definition" : "Date and time of issue of the medical assessment.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
