# A.2.1 - Lékařská prohlídka - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.1 - Lékařská prohlídka**

## Logical Model: A.2.1 - Lékařská prohlídka 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/LogMedicalExaminationCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzMedicalExaminationCz |

 
Zjištění o zdravotním stavu posuzované osoby a komplexní fyzikální vyšetření 

**Usages:**

* Use this Logical Model: [A - Elektronický lékařský posudek](StructureDefinition-LogElpCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/LogMedicalExaminationCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogMedicalExaminationCz.csv), [Excel](StructureDefinition-LogMedicalExaminationCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogMedicalExaminationCz",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/LogMedicalExaminationCz",
  "version" : "0.0.1",
  "name" : "LogCzMedicalExaminationCz",
  "title" : "A.2.1 - Lékařská prohlídka",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Zjištění o zdravotním stavu posuzované osoby a komplexní fyzikální vyšetření",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/elp/StructureDefinition/LogMedicalExaminationCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogMedicalExaminationCz",
        "path" : "LogMedicalExaminationCz",
        "short" : "A.2.1 - Lékařská prohlídka",
        "definition" : "Zjištění o zdravotním stavu posuzované osoby a komplexní fyzikální vyšetření"
      },
      {
        "id" : "LogMedicalExaminationCz.druhProhlidky",
        "path" : "LogMedicalExaminationCz.druhProhlidky",
        "short" : "A.2.1.1 - Druh prohlídky",
        "definition" : "Lékařská prohlídka může být vstupní, pravidelná nebo mimořádná. Z číselníku Číselník DruhProhlidkyRO.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogMedicalExaminationCz.posouzeniPodleSkupiny",
        "path" : "LogMedicalExaminationCz.posouzeniPodleSkupiny",
        "short" : "A.2.1.2 - Posouzení podle skupiny",
        "definition" : "Posouzení podle skoupiny z Číselníku SkupinaZadatelRidicRo.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogMedicalExaminationCz.datumProhlidky",
        "path" : "LogMedicalExaminationCz.datumProhlidky",
        "short" : "A.2.1.3 - Datum prohlídky",
        "definition" : "Datum a čas provedení lékařské prohlídky.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogMedicalExaminationCz.odborneVysetreni",
        "path" : "LogMedicalExaminationCz.odborneVysetreni",
        "short" : "A.2.1.4 - Odborné vyšetření",
        "definition" : "Informace o odborném vyšetření, zda bylo provedeno a případně jaké.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogMedicalExaminationCz.odborneVysetreni.typ",
        "path" : "LogMedicalExaminationCz.odborneVysetreni.typ",
        "short" : "A.2.1.4.1 - Typ vyšetření",
        "definition" : "Typ vyšetření z Číselníku TypOdbornehoVysetreni.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogMedicalExaminationCz.odborneVysetreni.datum",
        "path" : "LogMedicalExaminationCz.odborneVysetreni.datum",
        "short" : "A.2.1.4.2 - Datum vyšetření",
        "definition" : "Datum a čas provedení odborného vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
