# A.1 - Document header - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1 - Document header**

## Logical Model: A.1 - Document header 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/HeaderElpCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnHeaderElpCz |

 
Header of the electronic medical report according to Czech specifications. 

**Usages:**

* Use this Logical Model: [A - Electronic Medical Report](StructureDefinition-ElpCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/HeaderElpCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HeaderElpCz.csv), [Excel](StructureDefinition-HeaderElpCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HeaderElpCz",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/HeaderElpCz",
  "version" : "0.0.1",
  "name" : "LogEnHeaderElpCz",
  "title" : "A.1 - Document header",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Header of the electronic medical report according to Czech specifications.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/elp/StructureDefinition/HeaderElpCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HeaderElpCz",
        "path" : "HeaderElpCz",
        "short" : "A.1 - Document header",
        "definition" : "Header of the electronic medical report according to Czech specifications."
      },
      {
        "id" : "HeaderElpCz.patient",
        "path" : "HeaderElpCz.patient",
        "short" : "A.1.1 - Patient",
        "definition" : "Patient information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.patient.rid",
        "path" : "HeaderElpCz.patient.rid",
        "short" : "A.1.1.1 - RID",
        "definition" : "Patient's National Health Sector Identifier.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.patient.name",
        "path" : "HeaderElpCz.patient.name",
        "short" : "A.1.1.2 - Name",
        "definition" : "Name of the patient.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.patient.lastName",
        "path" : "HeaderElpCz.patient.lastName",
        "short" : "A.1.1.3 - Last name",
        "definition" : "Patient's last name.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.patient.dateOfBirth",
        "path" : "HeaderElpCz.patient.dateOfBirth",
        "short" : "A.1.1.4 - Date of birth",
        "definition" : "Patient's date of birth.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.patient.address",
        "path" : "HeaderElpCz.patient.address",
        "short" : "A.1.1.5 - Address",
        "definition" : "Citizenship according to Act 186/2013. Citizenship as stated on official identity documents.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.patient.contact",
        "path" : "HeaderElpCz.patient.contact",
        "short" : "A.1.1.6 - Contact",
        "definition" : "Patient contact details (email, telephone).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.patient.documentType",
        "path" : "HeaderElpCz.patient.documentType",
        "short" : "A.1.1.7 - Document type",
        "definition" : "The medical report includes information about the patient's identity document. From the DocumentType code list",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.patient.documentNumber",
        "path" : "HeaderElpCz.patient.documentNumber",
        "short" : "A.1.1.8 - Document Number",
        "definition" : "The number of the patient's identity document.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.assessingPhysician",
        "path" : "HeaderElpCz.assessingPhysician",
        "short" : "A.1.2 - Assessing Physician",
        "definition" : "Information about the assessing physician.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.assessingPhysician.id",
        "path" : "HeaderElpCz.assessingPhysician.id",
        "short" : "A.1.2.1 - ID",
        "definition" : "Identification number of the healthcare professional. Either an internal identifier assigned by the healthcare provider institution or (preferably) the national ID of the healthcare professional, such as a license number or registration number.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.assessingPhysician.firstName",
        "path" : "HeaderElpCz.assessingPhysician.firstName",
        "short" : "A.1.2.2 - First name",
        "definition" : "First name of the assessing physician.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.assessingPhysician.lastName",
        "path" : "HeaderElpCz.assessingPhysician.lastName",
        "short" : "A.1.2.3 - Last name",
        "definition" : "Last name of the assessing physician.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.assessingPhysician.specialty",
        "path" : "HeaderElpCz.assessingPhysician.specialty",
        "short" : "A.1.2.4 - Specialty",
        "definition" : "Specialty of the assessing physician. From the HealthcareProfessionalSpecialty code list",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.assessingPhysician.providerID",
        "path" : "HeaderElpCz.assessingPhysician.providerID",
        "short" : "A.1.2.5 - Provider ID",
        "definition" : "Identification number of the healthcare provider where the assessing physician is employed. Either an internal identifier assigned by the healthcare provider institution or (preferably) a national healthcare provider ID, such as IČZ.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.assessingPhysician.providerName",
        "path" : "HeaderElpCz.assessingPhysician.providerName",
        "short" : "A.1.2.6 - Provider name",
        "definition" : "Name of the healthcare provider where the assessing physician is employed.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.assessingPhysician.providerAddress",
        "path" : "HeaderElpCz.assessingPhysician.providerAddress",
        "short" : "A.1.2.7 - Provider Address",
        "definition" : "Address of the healthcare provider where the assessing physician is employed.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.metadata",
        "path" : "HeaderElpCz.metadata",
        "short" : "A.1.3 - Metadata",
        "definition" : "Metadata of the document.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.metadata.id",
        "path" : "HeaderElpCz.metadata.id",
        "short" : "A.1.3.1 - ID",
        "definition" : "Unique identifier of the medical assessment.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.metadata.category",
        "path" : "HeaderElpCz.metadata.category",
        "short" : "A.1.3.2 - Category",
        "definition" : "Category of the electronic health record (EHR).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.metadata.status",
        "path" : "HeaderElpCz.metadata.status",
        "short" : "A.1.3.3 - Status",
        "definition" : "Status of the document.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.metadata.creationDate",
        "path" : "HeaderElpCz.metadata.creationDate",
        "short" : "A.1.3.4 - Creation date",
        "definition" : "Date and time of creation of the medical report.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.metadata.filename",
        "path" : "HeaderElpCz.metadata.filename",
        "short" : "A.1.3.5 - Filename",
        "definition" : "Filename of the medical report.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.metadata.documentManager",
        "path" : "HeaderElpCz.metadata.documentManager",
        "short" : "A.1.3.6 - Document Manager",
        "definition" : "Manager of the medical report.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.metadata.confidentiality",
        "path" : "HeaderElpCz.metadata.confidentiality",
        "short" : "A.1.3.7 - Confidentiality",
        "definition" : "Confidentiality level of the medical report.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.metadata.language",
        "path" : "HeaderElpCz.metadata.language",
        "short" : "A.1.3.8 - Language",
        "definition" : "The language in which the medical report is written.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.metadata.version",
        "path" : "HeaderElpCz.metadata.version",
        "short" : "A.1.3.9 - Version",
        "definition" : "The version of the medical report.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.metadata.electronicSignature",
        "path" : "HeaderElpCz.metadata.electronicSignature",
        "short" : "A.1.3.10 - Electronic signature",
        "definition" : "Electronic signature or seal of the document.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Signature"
          }
        ]
      },
      {
        "id" : "HeaderElpCz.metadata.timestamp",
        "path" : "HeaderElpCz.metadata.timestamp",
        "short" : "A.1.3.11 - Timestamp",
        "definition" : "Electronic timestamp.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      }
    ]
  }
}

```
