# A - Electronic Medical Report - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A - Electronic Medical Report**

## Logical Model: A - Electronic Medical Report 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/ElpCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnElpCz |

 
Logical model of Electronic Medical Report according to Czech specifications 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/ElpCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ElpCz.csv), [Excel](StructureDefinition-ElpCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ElpCz",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/ElpCz",
  "version" : "0.0.1",
  "name" : "LogEnElpCz",
  "title" : "A - Electronic Medical Report",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Logical model of Electronic Medical Report according to Czech specifications",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/elp/StructureDefinition/ElpCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ElpCz",
        "path" : "ElpCz",
        "short" : "A - Electronic Medical Report",
        "definition" : "Logical model of Electronic Medical Report according to Czech specifications"
      },
      {
        "id" : "ElpCz.header",
        "path" : "ElpCz.header",
        "short" : "A.1 - Document header",
        "definition" : "Header of the electronic medical assessment according to Czech specifications",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/elp/StructureDefinition/HeaderElpCz"
          }
        ]
      },
      {
        "id" : "ElpCz.body",
        "path" : "ElpCz.body",
        "short" : "A.2 - Document body",
        "definition" : "The body contains the assessment for a driver's license",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ElpCz.body.medicalExamination",
        "path" : "ElpCz.body.medicalExamination",
        "short" : "A.2.1 - Medical examination",
        "definition" : "Findings on the health status of the person being assessed and a comprehensive physical examination",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalExaminationCz"
          }
        ]
      },
      {
        "id" : "ElpCz.body.medicalReport",
        "path" : "ElpCz.body.medicalReport",
        "short" : "A.2.2 - Medical report",
        "definition" : "The report must be unambiguous and must not contain a diagnosis of illness",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalReportCz"
          }
        ]
      },
      {
        "id" : "ElpCz.body.result",
        "path" : "ElpCz.body.result",
        "short" : "A.2.3 - Result of the assessment",
        "definition" : "Result of the assessment of medical fitness to drive motor vehicles",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/elp/StructureDefinition/ResultCz"
          }
        ]
      }
    ]
  }
}

```
