# CZ Result Model to this guide Map - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Result Model to this guide Map**

## ConceptMap: CZ Result Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/ConceptMap/Result2FHIR-cz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:Result2FHIR |

 
CZ Electronic Result Header Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "Result2FHIR-cz",
  "url" : "https://hl7.cz/fhir/elp/ConceptMap/Result2FHIR-cz",
  "version" : "0.0.1",
  "name" : "Result2FHIR",
  "title" : "CZ Result Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Electronic Result Header Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/ResultCz",
      "target" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-composition-elp",
      "element" : [
        {
          "code" : "ResultCz",
          "display" : "A.2.3 - Result of the medical report",
          "target" : [
            {
              "code" : "CZ_CompositionElp.section:medicalReport.entry",
              "display" : "to DiagnosticReport or ObservationResult",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalReportCz",
      "target" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-diagnostic-report-elp",
      "element" : [
        {
          "code" : "ResultCz.medicalfitness",
          "display" : "A.2.3.1 - Medical fitness",
          "target" : [
            {
              "code" : "CZ_DiagnosticReportElp.conclusionCode",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "ResultCz.justification",
          "display" : "A.2.3.5 - Justification for restriction or condition",
          "target" : [
            {
              "code" : "CZ_DiagnosticReportElp.conclusion",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalReportCz",
      "target" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-observation-result-elp",
      "element" : [
        {
          "code" : "ResultCz.restrictionsHarmonizedCodes",
          "display" : "A.2.3.2 - Restrictions/conditions for driving a motor vehicle - harmonized codes",
          "target" : [
            {
              "code" : "CZ_ObservationResultElp.component:harmonizedCodes.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "ResultCz.restrictionsNationalCodes",
          "display" : "A.2.3.3 - Restrictions/conditions for driving a motor vehicle – national codes",
          "target" : [
            {
              "code" : "CZ_ObservationResultElp.component:nationalCodes.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "ResultCz.specificationRestriction",
          "display" : "A.2.3.4 - Specification of restrictions/conditions for driving a motor vehicle",
          "target" : [
            {
              "code" : "CZ_ObservationResultElp.component:clarification.code",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
