# CZ Medical Report Model to this guide Map - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Medical Report Model to this guide Map**

## ConceptMap: CZ Medical Report Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/ConceptMap/MedicalReport2FHIR-cz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:MedicalReport2FHIR |

 
CZ Electronic Medical Report Header Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "MedicalReport2FHIR-cz",
  "url" : "https://hl7.cz/fhir/elp/ConceptMap/MedicalReport2FHIR-cz",
  "version" : "0.0.1",
  "name" : "MedicalReport2FHIR",
  "title" : "CZ Medical Report Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Electronic Medical Report Header Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalReportCz",
      "target" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-composition-elp",
      "element" : [
        {
          "code" : "MedicalReportCz",
          "display" : "A.2.2 - Medical Report",
          "target" : [
            {
              "code" : "CZ_CompositionElp.section:medicalReport.entry",
              "display" : "to DiagnosticReport or ObservationResult",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalReportCz",
      "target" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-diagnostic-report-elp",
      "element" : [
        {
          "code" : "MedicalReportCz.typeOfAssessment",
          "display" : "A.2.2.1 - Type of assessment",
          "target" : [
            {
              "code" : "CZ_DiagnosticReportElp.category",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "MedicalReportCz.dateValidUntil",
          "display" : "A.2.2.3 - Date of validity of the assessment",
          "target" : [
            {
              "code" : "CZ_DiagnosticReportElp.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "MedicalReportCz.dateOfIssueOfAssessment",
          "display" : "A.2.2.4 - Date of issue of assessment",
          "target" : [
            {
              "code" : "CZ_DiagnosticReportElp.issued",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalReportCz",
      "target" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-observation-result-elp",
      "element" : [
        {
          "code" : "MedicalReportCz.drivingLicenseGroup",
          "display" : "A.2.2.2 - Driving license group",
          "target" : [
            {
              "code" : "CZ_DiagnosticReportElp.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "MedicalReportCz.dateOfIssueOfAssessment",
          "display" : "A.2.2.4 - Date of issue of assessment",
          "target" : [
            {
              "code" : "CZ_ObservationResultElp.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
