# CZ Header Model to this guide Map - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Header Model to this guide Map**

## ConceptMap: CZ Header Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/ConceptMap/Header2FHIR-cz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:Header2FHIR |

 
CZ Electronic Medical Report Header Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "Header2FHIR-cz",
  "url" : "https://hl7.cz/fhir/elp/ConceptMap/Header2FHIR-cz",
  "version" : "0.0.1",
  "name" : "Header2FHIR",
  "title" : "CZ Header Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Electronic Medical Report Header Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/HeaderElpCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
      "element" : [
        {
          "code" : "Header.patient",
          "display" : "A.1.1 Patient",
          "target" : [
            {
              "code" : "Patient",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.patient.rid",
          "display" : "A.1.1.1 RID",
          "target" : [
            {
              "code" : "Patient.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.patient.name",
          "display" : "A.1.1.2 Name",
          "target" : [
            {
              "code" : "Patient.name.given",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.patient.lastName",
          "display" : "A.1.1.3 Last name",
          "target" : [
            {
              "code" : "Patient.name.family",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.patient.dateOfBirth",
          "display" : "A.1.1.4 Date of birth",
          "target" : [
            {
              "code" : "Patient.dateOfBirth",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.patient.address",
          "display" : "A.1.1.5 Patient address",
          "target" : [
            {
              "code" : "Patient.address",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.patient.contact",
          "display" : "A.1.1.6 Patient contact",
          "target" : [
            {
              "code" : "Patient.telecom",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.patient.documentType",
          "display" : "A.1.1.7 Document type",
          "target" : [
            {
              "code" : "Patient.identifier.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.patient.documentNumber",
          "display" : "A.1.1.8 Document Number",
          "target" : [
            {
              "code" : "Patient.identifier.value",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/HeaderElpCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
      "element" : [
        {
          "code" : "Header.assessingPhysician",
          "display" : "A.1.2 - Assessing Physician",
          "target" : [
            {
              "code" : "PractitionerRole",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.assessingPhysician.id",
          "display" : "A.1.2.1 - ID",
          "target" : [
            {
              "code" : "PractitionerRole.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.assessingPhysician.firstName",
          "display" : "A.1.2.2 - First name",
          "target" : [
            {
              "code" : "PractitionerRole.practictioner.name.given",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.assessingPhysician.lastName",
          "display" : "A.1.2.3 - Last name",
          "target" : [
            {
              "code" : "PractitionerRole.practictioner.name.family",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.assessingPhysician.specialty",
          "display" : "A.1.2.4 - Specialty",
          "target" : [
            {
              "code" : "PractitionerRole.specialty",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.assessingPhysician.providerID",
          "display" : "A.1.2.5 - Provider ID",
          "target" : [
            {
              "code" : "PractitionerRole.organization.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.assessingPhysician.providerName",
          "display" : "A.1.2.6 - Provider name",
          "target" : [
            {
              "code" : "PractitionerRole.organization.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.assessingPhysician.providerAddress",
          "display" : "A.1.2.7 - Provider Address",
          "target" : [
            {
              "code" : "PractitionerRole.organization.address",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/HeaderElpCz",
      "target" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-bundle-elp",
      "element" : [
        {
          "code" : "Header.metadata.identifier",
          "display" : "A.1.3.1 - Document ID",
          "target" : [
            {
              "code" : "Bundle.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.metadata.dateTime",
          "display" : "A.1.3.4 - Creation date",
          "target" : [
            {
              "code" : "Bundle.timeStamp",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.metadata.electronicSignature",
          "display" : "A.1.3.10 - Digital signature",
          "target" : [
            {
              "code" : "Bundle.signature.data",
              "equivalence" : "equivalent",
              "comment" : "Digital signature of the Bundle"
            }
          ]
        },
        {
          "code" : "Header.metadata.timestamp",
          "display" : "A.1.3.11 - Timestamp",
          "target" : [
            {
              "code" : "Bundle.signature.when",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/HeaderElpCz",
      "target" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-composition-elp",
      "element" : [
        {
          "code" : "Header.patient",
          "display" : "A.1.1 - Patient",
          "target" : [
            {
              "code" : "Composition.subject",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.author",
          "display" : "A.1.2 - Assessing Physician",
          "target" : [
            {
              "code" : "Composition.author",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.metadata",
          "display" : "A.1.3 - Metadata",
          "target" : [
            {
              "code" : "Composition.documentMetadata",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.metadata.id",
          "display" : "A.1.3.1 - ID",
          "target" : [
            {
              "code" : "Composition.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.metadata.category",
          "display" : "A.1.3.2 - Category",
          "target" : [
            {
              "code" : "Composition.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.metadata.status",
          "display" : "A.1.3.3 - Status",
          "target" : [
            {
              "code" : "Composition.status",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.metadata.creationDate",
          "display" : "A.1.3.4 - Creation date",
          "target" : [
            {
              "code" : "Composition.date",
              "equivalence" : "equivalent",
              "comment" : "If it is when this document has been created (indipendently by its version)"
            }
          ]
        },
        {
          "code" : "Header.metadata.filename",
          "display" : "A.1.3.5 - Filename",
          "target" : [
            {
              "code" : "Composition.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.metadata.documentManager",
          "display" : "A.1.3.6 - Document manager",
          "target" : [
            {
              "code" : "Composition.custodian.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.metadata.confidentiality",
          "display" : "A.1.3.7 - Confidentiality",
          "target" : [
            {
              "code" : "Composition.confidentiality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.metadata.language",
          "display" : "A.1.3.8 - Language",
          "target" : [
            {
              "code" : "Composition.language",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.version",
          "display" : "A.1.3.9 - Version",
          "target" : [
            {
              "code" : "Composition.extension:versionNumber.valueString",
              "equivalence" : "equivalent",
              "comment" : "As business version, not as resource version"
            }
          ]
        }
      ]
    }
  ]
}

```
