# Restriction national code value set - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Restriction national code value set**

## ValueSet: Restriction national code value set 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-narodni-kody | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_RestrictionNationalCodeELPVS |

 
Restriction national code value set 

 **References** 

* [Observation of medical report (ELP CZ)](StructureDefinition-cz-observation-result-elp.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-restriction-national-code-elp-vs",
  "url" : "https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-narodni-kody",
  "version" : "0.0.1",
  "name" : "CZ_RestrictionNationalCodeELPVS",
  "title" : "Restriction national code value set",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Restriction national code value set",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/elp-ro",
        "concept" : [
          {
            "code" : "105",
            "display" : "105. Jiná zdravotní omezení, která nejsou uvedena v části I této přílohy."
          },
          {
            "code" : "111a",
            "display" : "111. Nelze vykonávat činnost: a) řidiče, který řídí motorové vozidlo v pracovněprávním vztahu a u něhož je řízení motorového vozidla druhem práce sjednaným v pracovní smlouvě"
          },
          {
            "code" : "111b",
            "display" : "111. Nelze vykonávat činnost: b) řidiče, u kterého je řízení motorového vozidla předmětem samostatné výdělečné činnosti prováděné podle jiného právního předpisu"
          },
          {
            "code" : "111c",
            "display" : "111. Nelze vykonávat činnost: c) učitele výcviku v řízení motorových vozidel podle jiného právního předpisu"
          },
          {
            "code" : "115",
            "display" : "115. Posilovač spojky"
          },
          {
            "code" : "160",
            "display" : "160. Výjimka z věku u řidičského oprávnění skupiny vozidel A1, A2 nebo A osoby, která je držitelem licence motoristického sportovce, udělená pouze pro jízdu při sportovní soutěži"
          },
          {
            "code" : "172",
            "display" : "172. Omezení řidičského oprávnění skupiny vozidel A pouze k řízení motorového vozíku pro invalidy"
          },
          {
            "code" : "175",
            "display" : "175. Omezení řidičského oprávnění skupiny vozidel D pouze k řízení vozidla městské hromadné dopravy osob"
          },
          {
            "code" : "185",
            "display" : "185. Pouze pro řízení motorových vozidel stanovených v § 83 odst. 5 zákona č. 361/2000 Sb. do doby dosažení věku u skupiny vozidel C 21 let, u skupiny vozidel D 24 let"
          },
          {
            "code" : "199",
            "display" : "199. Zkušební doba podmíněného upuštění od výkon"
          }
        ]
      }
    ]
  }
}

```
