# Observation of medical report (ELP CZ) - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation of medical report (ELP CZ)**

## Resource Profile: Observation of medical report (ELP CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/cz-observation-result-elp | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_ObservationResultElp |

 
Appointment used to represent an observation of medical report for the scope of this guide. 

**Usages:**

* Use this Profile: [Bundle (ELP CZ)](StructureDefinition-cz-bundle-elp.md)
* Refer to this Profile: [Diagnostic Report (ELP CZ)](StructureDefinition-cz-diagnostic-report-elp.md)
* Examples for this Profile: [Observation/9994fdeb-dc0c-43aa-a998-6f02e7b88d32](Observation-9994fdeb-dc0c-43aa-a998-6f02e7b88d32.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/cz-observation-result-elp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-observation-result-elp.csv), [Excel](StructureDefinition-cz-observation-result-elp.xlsx), [Schematron](StructureDefinition-cz-observation-result-elp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-observation-result-elp",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-observation-result-elp",
  "version" : "0.0.1",
  "name" : "CZ_ObservationResultElp",
  "title" : "Observation of medical report (ELP CZ)",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Appointment used to represent an observation of medical report for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "225317005",
              "display" : "Restriction of movement"
            }
          ]
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.effective[x]:effectiveDateTime",
        "path" : "Observation.effective[x]",
        "sliceName" : "effectiveDateTime",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept",
        "path" : "Observation.value[x]",
        "sliceName" : "valueCodeableConcept",
        "short" : "vehicle type to which the restrictions apply",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-seznam-skupin"
        }
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Components of the colonoscopy observation",
        "min" : 1
      },
      {
        "id" : "Observation.component:harmonizedCodes",
        "path" : "Observation.component",
        "sliceName" : "harmonizedCodes",
        "short" : "Restrictions in harmonized codes",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:harmonizedCodes.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://hl7.cz/fhir/elp/CodeSystem/cz-restriction-type-elp-cs",
              "code" : "1",
              "display" : "Omezení/podmínky pro řízení motorového vozidla – harmonizované kódy"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:harmonizedCodes.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:harmonizedCodes.value[x]:valueCodeableConcept",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-harmonizovane-kody"
        }
      },
      {
        "id" : "Observation.component:nationalCodes",
        "path" : "Observation.component",
        "sliceName" : "nationalCodes",
        "short" : "Restrictions in national codes",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:nationalCodes.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://hl7.cz/fhir/elp/CodeSystem/cz-restriction-type-elp-cs",
              "code" : "2",
              "display" : "Omezení/podmínky pro řízení motorového vozidla – národní kódy"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:nationalCodes.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:nationalCodes.value[x]:valueCodeableConcept",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-narodni-kody"
        }
      },
      {
        "id" : "Observation.component:clarification",
        "path" : "Observation.component",
        "sliceName" : "clarification",
        "short" : "Clarification of restrictions",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:clarification.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://hl7.cz/fhir/elp/CodeSystem/cz-restriction-type-elp-cs",
              "code" : "3",
              "display" : "Upřesnění omezení"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:clarification.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:clarification.value[x]:valueCodeableConcept",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/elp/ValueSet/cz-restriction-clarification-elp-vs"
        }
      }
    ]
  }
}

```
