# Appointment (ELP CZ) - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Appointment (ELP CZ)**

## Resource Profile: Appointment (ELP CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/cz-appointment-elp | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_AppointmentElp |

 
Appointment used to represent a medical examination for the scope of this guide. 

**Usages:**

* Use this Profile: [Bundle (ELP CZ)](StructureDefinition-cz-bundle-elp.md)
* Refer to this Profile: [Composition (ELP CZ)](StructureDefinition-cz-composition-elp.md)
* Examples for this Profile: [Appointment/064c136d-0d08-4b8f-bd76-8d79de3ee99e](Appointment-064c136d-0d08-4b8f-bd76-8d79de3ee99e.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/cz-appointment-elp)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-appointment-elp.csv), [Excel](StructureDefinition-cz-appointment-elp.xlsx), [Schematron](StructureDefinition-cz-appointment-elp.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-appointment-elp",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-appointment-elp",
  "version" : "0.0.1",
  "name" : "CZ_AppointmentElp",
  "title" : "Appointment (ELP CZ)",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Appointment used to represent a medical examination for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "ical",
      "uri" : "http://ietf.org/rfc/2445",
      "name" : "iCalendar"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Appointment",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Appointment",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Appointment",
        "path" : "Appointment"
      },
      {
        "id" : "Appointment.status",
        "path" : "Appointment.status",
        "patternCode" : "arrived"
      },
      {
        "id" : "Appointment.serviceCategory",
        "path" : "Appointment.serviceCategory",
        "short" : "Categorization by type of inspection",
        "definition" : "This section holds information about type of inspection.",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-druh-prohlidky"
        }
      },
      {
        "id" : "Appointment.serviceType",
        "path" : "Appointment.serviceType",
        "short" : "Type according to group classification",
        "definition" : "This section holds information about group classification.",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/elp-ro-zadatel-skupina"
        }
      },
      {
        "id" : "Appointment.end",
        "path" : "Appointment.end",
        "short" : "Date when appointment has been realized",
        "min" : 1
      },
      {
        "id" : "Appointment.participant.actor",
        "path" : "Appointment.participant.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      }
    ]
  }
}

```
