# A.2.1 - Medical Examination - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.1 - Medical Examination**

## Logical Model: A.2.1 - Medical Examination 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/MedicalExaminationCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnMedicalExaminationCz |

 
Findings on the health status of the person being examined and comprehensive physical examination 

**Usages:**

* Use this Logical Model: [A - Electronic Medical Report](StructureDefinition-ElpCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/MedicalExaminationCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicalExaminationCz.csv), [Excel](StructureDefinition-MedicalExaminationCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicalExaminationCz",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalExaminationCz",
  "version" : "0.0.1",
  "name" : "LogEnMedicalExaminationCz",
  "title" : "A.2.1 - Medical Examination",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Findings on the health status of the person being examined and comprehensive physical examination",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalExaminationCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "MedicalExaminationCz",
        "path" : "MedicalExaminationCz",
        "short" : "A.2.1 - Medical Examination",
        "definition" : "Findings on the health status of the person being examined and comprehensive physical examination"
      },
      {
        "id" : "MedicalExaminationCz.typeOfExamination",
        "path" : "MedicalExaminationCz.typeOfExamination",
        "short" : "A.2.1.1 - Type of examination",
        "definition" : "A medical examination can be initial, regular, or extraordinary. From the TypeOfExamination code list.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicalExaminationCz.assessmentByGroup",
        "path" : "MedicalExaminationCz.assessmentByGroup",
        "short" : "A.2.1.2 - Assessment by group",
        "definition" : "Assessment by group from the ApplicantGroupCode list.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicalExaminationCz.examinationDate",
        "path" : "MedicalExaminationCz.examinationDate",
        "short" : "A.2.1.3 - Examination date",
        "definition" : "Date and time of the medical examination.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "MedicalExaminationCz.specialistExamination",
        "path" : "MedicalExaminationCz.specialistExamination",
        "short" : "A.2.1.4 - Specialist examination",
        "definition" : "Information about the specialist examination, whether it was performed and, if so, what type.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "MedicalExaminationCz.specialistExamination.type",
        "path" : "MedicalExaminationCz.specialistExamination.type",
        "short" : "A.2.1.4.1 - Type of examination",
        "definition" : "Type of examination from the TypeOfSpecialistExamination code list.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "MedicalExaminationCz.specialistExamination.date",
        "path" : "MedicalExaminationCz.specialistExamination.date",
        "short" : "A.2.1.4.2 - Date of examination",
        "definition" : "Date and time of the specialized examination.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
