# A.2.3 - Výsledek posudku - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.3 - Výsledek posudku**

## Logical Model: A.2.3 - Výsledek posudku 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/LogResultCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzResultCz |

 
Výsledek posudku o zdravotní způsobilosti k řízení motorových vozidel 

**Usages:**

* Use this Logical Model: [A - Elektronický lékařský posudek](StructureDefinition-LogElpCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/LogResultCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogResultCz.csv), [Excel](StructureDefinition-LogResultCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogResultCz",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/LogResultCz",
  "version" : "0.0.1",
  "name" : "LogCzResultCz",
  "title" : "A.2.3 - Výsledek posudku",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Výsledek posudku o zdravotní způsobilosti k řízení motorových vozidel",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/elp/StructureDefinition/LogResultCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogResultCz",
        "path" : "LogResultCz",
        "short" : "A.2.3 - Výsledek posudku",
        "definition" : "Výsledek posudku o zdravotní způsobilosti k řízení motorových vozidel"
      },
      {
        "id" : "LogResultCz.zdravotniZpusobilost",
        "path" : "LogResultCz.zdravotniZpusobilost",
        "short" : "A.2.3.1 - Zdravotní způsobilost",
        "definition" : "Hodnota z Číselníku VysledekPosudkuRo, která udává, zda je posuzovaná osoba zdravotně způsobilá k řízení motorových vozidel.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogResultCz.omezeniHarmonizovaneKody",
        "path" : "LogResultCz.omezeniHarmonizovaneKody",
        "short" : "A.2.3.2 - Omezení/podmínky pro řízení motorového vozidla – harmonizované kódy",
        "definition" : "Omezení zdravotní způsobilosti k řízení motorových vozidel podle Číselníku SeznamHarmonizovaneKodyRO.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogResultCz.omezeniNarodniKody",
        "path" : "LogResultCz.omezeniNarodniKody",
        "short" : "A.2.3.3 - Omezení/podmínky pro řízení motorového vozidla – národní kódy",
        "definition" : "Omezení zdravotní způsobilosti k řízení motorových vozidel podle Číselníku SeznamNarodniKodyRO.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogResultCz.upresneniOmezeni",
        "path" : "LogResultCz.upresneniOmezeni",
        "short" : "A.2.3.4 - Upřesnění omezení/podmínek pro řízení motorového vozidla",
        "definition" : "Jedná se o písmena pro použití v kombinaci s harmonizovanými kódy 01 až 44 pro další specifikaci omezení odle Číselníku SeznamUpresneniKoduRo.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogResultCz.zduvodneni",
        "path" : "LogResultCz.zduvodneni",
        "short" : "A.2.3.5 - Zdůvodnění k omezení či podmínce",
        "definition" : "Textový popis posuzujícího lékaře k omezení či podmínce pro řízení motorového vozidla.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
