# A.2.2 - Lékařský posudek - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.2 - Lékařský posudek**

## Logical Model: A.2.2 - Lékařský posudek 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/LogMedicalReportCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzMedicalReportCz |

 
Posudek musí být jednoznačný a nesmí obsahovat diagnózu nemoci 

**Usages:**

* Use this Logical Model: [A - Elektronický lékařský posudek](StructureDefinition-LogElpCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/LogMedicalReportCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogMedicalReportCz.csv), [Excel](StructureDefinition-LogMedicalReportCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogMedicalReportCz",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/LogMedicalReportCz",
  "version" : "0.0.1",
  "name" : "LogCzMedicalReportCz",
  "title" : "A.2.2 - Lékařský posudek",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Posudek musí být jednoznačný a nesmí obsahovat diagnózu nemoci",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/elp/StructureDefinition/LogMedicalReportCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogMedicalReportCz",
        "path" : "LogMedicalReportCz",
        "short" : "A.2.2 - Lékařský posudek",
        "definition" : "Posudek musí být jednoznačný a nesmí obsahovat diagnózu nemoci"
      },
      {
        "id" : "LogMedicalReportCz.druhPosudku",
        "path" : "LogMedicalReportCz.druhPosudku",
        "short" : "A.2.2.1 - Druh posudku",
        "definition" : "Typový druh posudku pro řidičské oprávnění podle Číselníku DruhPosudkuRO.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogMedicalReportCz.skupinaRidickehoOpravneni",
        "path" : "LogMedicalReportCz.skupinaRidickehoOpravneni",
        "short" : "A.2.2.2 - Skupina řidičského oprávnění",
        "definition" : "Řidičské oprávnění opravňuje jeho držitele k řízení motorového vozidla zařazeného do skupiny vozidel, pro kterou mu bylo řidičské oprávnění uděleno. Hodnoty jsou z Číselník SeznamSkupinRo.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogMedicalReportCz.datumPlatnostiPosudkuDo",
        "path" : "LogMedicalReportCz.datumPlatnostiPosudkuDo",
        "short" : "A.2.2.3 - Datum platnosti posudku",
        "definition" : "Datum ukončení platnosti lékařského posudku.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogMedicalReportCz.datumVystaveniPosudku",
        "path" : "LogMedicalReportCz.datumVystaveniPosudku",
        "short" : "A.2.2.4 - Datum vystavení posudku",
        "definition" : "Datum a čas vystavení lékařského posudku.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
