# A.1 - Hlavička dokumentu - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1 - Hlavička dokumentu**

## Logical Model: A.1 - Hlavička dokumentu 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/LogHeaderElpCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzHeaderElpCz |

 
Hlavička elektronického lékařského posudku podle české specifikace. 

**Usages:**

* Use this Logical Model: [A - Elektronický lékařský posudek](StructureDefinition-LogElpCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/LogHeaderElpCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogHeaderElpCz.csv), [Excel](StructureDefinition-LogHeaderElpCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogHeaderElpCz",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/LogHeaderElpCz",
  "version" : "0.0.1",
  "name" : "LogCzHeaderElpCz",
  "title" : "A.1 - Hlavička dokumentu",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hlavička elektronického lékařského posudku podle české specifikace.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/elp/StructureDefinition/LogHeaderElpCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogHeaderElpCz",
        "path" : "LogHeaderElpCz",
        "short" : "A.1 - Hlavička dokumentu",
        "definition" : "Hlavička elektronického lékařského posudku podle české specifikace."
      },
      {
        "id" : "LogHeaderElpCz.pacient",
        "path" : "LogHeaderElpCz.pacient",
        "short" : "A.1.1 - Pacient",
        "definition" : "Údaje o pacientovi.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.pacient.rid",
        "path" : "LogHeaderElpCz.pacient.rid",
        "short" : "A.1.1.1 - RID",
        "definition" : "Resortní identifikátor pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.pacient.jmeno",
        "path" : "LogHeaderElpCz.pacient.jmeno",
        "short" : "A.1.1.2 - Jméno",
        "definition" : "Jméno pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.pacient.prijmeni",
        "path" : "LogHeaderElpCz.pacient.prijmeni",
        "short" : "A.1.1.3 - Příjmení",
        "definition" : "Příjmení pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.pacient.datumNarozeni",
        "path" : "LogHeaderElpCz.pacient.datumNarozeni",
        "short" : "A.1.1.4 - Datum narození",
        "definition" : "Datum narození pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.pacient.adresaPobytu",
        "path" : "LogHeaderElpCz.pacient.adresaPobytu",
        "short" : "A.1.1.5 - Adresa",
        "definition" : "Státní občanství dle zákona 186/2013. Státní občanství, jak je uváděno na oficiálních dokladech k prokázání identity.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.pacient.kontakt",
        "path" : "LogHeaderElpCz.pacient.kontakt",
        "short" : "A.1.1.6 - Kontakt",
        "definition" : "Kontaktní údaje na pacienta (email, telefon).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.pacient.druhDokladu",
        "path" : "LogHeaderElpCz.pacient.druhDokladu",
        "short" : "A.1.1.7 - Druh dokladu",
        "definition" : "Součástí lékařského posudku jsou informace o dokladu totožnosti pacienta. Z číselníku DruhDokladu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.pacient.cisloDokladu",
        "path" : "LogHeaderElpCz.pacient.cisloDokladu",
        "short" : "A.1.1.8 - Číslo dokladu",
        "definition" : "Číslo dokladu totožnosti pacienta.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.posuzujiciLekar",
        "path" : "LogHeaderElpCz.posuzujiciLekar",
        "short" : "A.1.2 - Posuzující lékař",
        "definition" : "Údaje o posuzujícím lékaři.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.posuzujiciLekar.id",
        "path" : "LogHeaderElpCz.posuzujiciLekar.id",
        "short" : "A.1.2.1 - ID",
        "definition" : "Identifikační číslo zdravotnického pracovníka. Buď interní identifikátor přidělený institucí poskytovatele zdravotní péče, nebo (nejlépe) národní ID zdravotnického pracovníka, jako je číslo licence nebo registrační číslo.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.posuzujiciLekar.jmeno",
        "path" : "LogHeaderElpCz.posuzujiciLekar.jmeno",
        "short" : "A.1.2.2 - Jméno",
        "definition" : "Jméno posuzujícího lékaře.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.posuzujiciLekar.prijmeni",
        "path" : "LogHeaderElpCz.posuzujiciLekar.prijmeni",
        "short" : "A.1.2.3 - Příjmení",
        "definition" : "Příjmení posuzujícího lékaře.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.posuzujiciLekar.odbornost",
        "path" : "LogHeaderElpCz.posuzujiciLekar.odbornost",
        "short" : "A.1.2.4 - Odbornost",
        "definition" : "Odbornost posuzujícího lékaře. Z číselníku OdbornostZdravotnickehoPracovnika",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.posuzujiciLekar.idPoskytovatele",
        "path" : "LogHeaderElpCz.posuzujiciLekar.idPoskytovatele",
        "short" : "A.1.2.5 - ID poskytovatele",
        "definition" : "Identifikační číslo poskytovatele zdravotní péče, kde je posuzující lékař zaměstnán. Buď interní identifikátor přidělený institucí poskytovatele zdravotní péče, nebo (nejlépe) národní ID poskytovatele zdravotní péče, jako je IČZ.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.posuzujiciLekar.nazevPoskytovatele",
        "path" : "LogHeaderElpCz.posuzujiciLekar.nazevPoskytovatele",
        "short" : "A.1.2.6 - Název poskytovatele",
        "definition" : "Název poskytovatele zdravotní péče, kde je posuzující lékař zaměstnán.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.posuzujiciLekar.adresaPoskytovatele",
        "path" : "LogHeaderElpCz.posuzujiciLekar.adresaPoskytovatele",
        "short" : "A.1.2.7 - Adresa poskytovatele",
        "definition" : "Adresa poskytovatele zdravotní péče, kde je posuzující lékař zaměstnán.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.metadata",
        "path" : "LogHeaderElpCz.metadata",
        "short" : "A.1.3 - Metadata",
        "definition" : "Metadata dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.metadata.id",
        "path" : "LogHeaderElpCz.metadata.id",
        "short" : "A.1.3.1 - ID",
        "definition" : "Jedinečný identifikátor lékařského posudku.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.metadata.kategorie",
        "path" : "LogHeaderElpCz.metadata.kategorie",
        "short" : "A.1.3.2 - Kategorie",
        "definition" : "Kategorie elektronického zdravotního záznamu (EHR)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.metadata.stav",
        "path" : "LogHeaderElpCz.metadata.stav",
        "short" : "A.1.3.3 - Stav",
        "definition" : "Stav dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.metadata.datumVytvoreni",
        "path" : "LogHeaderElpCz.metadata.datumVytvoreni",
        "short" : "A.1.3.4 - Datum vytvoření",
        "definition" : "Datum a čas vytvoření lékařského posudku.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.metadata.nazevSouboru",
        "path" : "LogHeaderElpCz.metadata.nazevSouboru",
        "short" : "A.1.3.5 - Název souboru",
        "definition" : "Název souboru lékařského posudku.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.metadata.spravceDokumentu",
        "path" : "LogHeaderElpCz.metadata.spravceDokumentu",
        "short" : "A.1.3.6 - Správce dokumentu",
        "definition" : "Správce dokumentu lékařského posudku.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.metadata.duvernost",
        "path" : "LogHeaderElpCz.metadata.duvernost",
        "short" : "A.1.3.7 - Důvěrnost",
        "definition" : "Úroveň důvěrnosti lékařského posudku.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.metadata.jazyk",
        "path" : "LogHeaderElpCz.metadata.jazyk",
        "short" : "A.1.3.8 - Jazyk",
        "definition" : "Jazyk, ve kterém je lékařský posudek napsán.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.metadata.verze",
        "path" : "LogHeaderElpCz.metadata.verze",
        "short" : "A.1.3.9 - Verze",
        "definition" : "Verze lékařského posudku.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.metadata.elektronickyPodpis",
        "path" : "LogHeaderElpCz.metadata.elektronickyPodpis",
        "short" : "A.1.3.10 - Elektronický podpis",
        "definition" : "Elektronický podpis nebo pečeť dokumentu-",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Signature"
          }
        ]
      },
      {
        "id" : "LogHeaderElpCz.metadata.casoveRazitko",
        "path" : "LogHeaderElpCz.metadata.casoveRazitko",
        "short" : "A.1.3.11 - Časové razítko",
        "definition" : "Elektronické časové razítko .",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      }
    ]
  }
}

```
