# A - Elektronický lékařský posudek - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A - Elektronický lékařský posudek**

## Logical Model: A - Elektronický lékařský posudek 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/StructureDefinition/LogElpCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzElpCz |

 
Logický model Elektronického lékařského posudku podle české specifikace 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.elp|current/StructureDefinition/LogElpCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogElpCz.csv), [Excel](StructureDefinition-LogElpCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogElpCz",
  "url" : "https://hl7.cz/fhir/elp/StructureDefinition/LogElpCz",
  "version" : "0.0.1",
  "name" : "LogCzElpCz",
  "title" : "A - Elektronický lékařský posudek",
  "status" : "draft",
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Logický model Elektronického lékařského posudku podle české specifikace",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/elp/StructureDefinition/LogElpCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogElpCz",
        "path" : "LogElpCz",
        "short" : "A - Elektronický lékařský posudek",
        "definition" : "Logický model Elektronického lékařského posudku podle české specifikace"
      },
      {
        "id" : "LogElpCz.hlavicka",
        "path" : "LogElpCz.hlavicka",
        "short" : "A.1 - Hlavička dokumentu",
        "definition" : "Hlavička elektronického lékařského posudku podle české specifikace",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/elp/StructureDefinition/LogHeaderElpCz"
          }
        ]
      },
      {
        "id" : "LogElpCz.telo",
        "path" : "LogElpCz.telo",
        "short" : "A.2 - Tělo dokumentu",
        "definition" : "Tělo obsahuje posudek pro řidičské oprávnění",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogElpCz.telo.lekarskaProhlidka",
        "path" : "LogElpCz.telo.lekarskaProhlidka",
        "short" : "A.2.1 - Lékařská prohlídka",
        "definition" : "Zjištění o zdravotním stavu posuzované osoby a komplexní fyzikální vyšetření",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/elp/StructureDefinition/LogMedicalExaminationCz"
          }
        ]
      },
      {
        "id" : "LogElpCz.telo.lekarskyPosudek",
        "path" : "LogElpCz.telo.lekarskyPosudek",
        "short" : "A.2.2 - Lékařský posudek",
        "definition" : "Posudek musí být jednoznačný a nesmí obsahovat diagnózu nemoci",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/elp/StructureDefinition/LogMedicalReportCz"
          }
        ]
      },
      {
        "id" : "LogElpCz.telo.vysledek",
        "path" : "LogElpCz.telo.vysledek",
        "short" : "A.2.3 - Výsledek posudku",
        "definition" : "Výsledek posudku o zdravotní způsobilosti k řízení motorových vozidel",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/elp/StructureDefinition/LogResultCz"
          }
        ]
      }
    ]
  }
}

```
