# Patient Mracena - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Patient Mracena**

## Example Patient: Patient Mracena

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Mračena Mrakomorová Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/op#1234567890)

-------

| | |
| :--- | :--- |
| Other Ids: | * `https://ncez.mzcr.cz/fhir/sid/rid`/2066425387
* Passport number/88476522 (use: official, )
 |
| Contact Detail | * [+420 603 853 227](tel:+420603853227)
* Malé náměstí 13a, 150 00, Praha 5(home)
 |
| Languages: | * Czech (preferred)
* English
* German
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "2f4dde8e-ad7d-432d-aa49-e995367bbfc3",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "2066425387"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PPN"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/NamingSystem/passportNumNS-CZE",
      "value" : "88476522"
    },
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/op",
      "value" : "1234567890"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Mrakomorová",
      "given" : ["Mračena"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420 603 853 227",
      "use" : "home"
    }
  ],
  "gender" : "female",
  "birthDate" : "1971-11-26",
  "address" : [
    {
      "use" : "home",
      "type" : "physical",
      "text" : "Malé náměstí 13a, 150 00, Praha 5",
      "line" : ["Malé náměstí 13a"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Malé náměstí"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "13a"
            }
          ]
        }
      ],
      "city" : "Praha",
      "postalCode" : "15000",
      "country" : "Česko",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "cs"
          }
        ]
      },
      "preferred" : true
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "en"
          }
        ]
      }
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "de"
          }
        ]
      }
    }
  ]
}

```
