# CZ Medical Examination Model to this guide Map - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Medical Examination Model to this guide Map**

## ConceptMap: CZ Medical Examination Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/elp/ConceptMap/MedicalExamination2FHIR-cz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:MedicalExamination2FHIR |

 
CZ Electronic Medical Report Header Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "MedicalExamination2FHIR-cz",
  "url" : "https://hl7.cz/fhir/elp/ConceptMap/MedicalExamination2FHIR-cz",
  "version" : "0.0.1",
  "name" : "MedicalExamination2FHIR",
  "title" : "CZ Medical Examination Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T13:03:51+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Electronic Medical Report Header Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalExaminationCz",
      "target" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-composition-elp",
      "element" : [
        {
          "code" : "MedicalExaminationCz",
          "display" : "A.2.1 - Medical examination",
          "target" : [
            {
              "code" : "CZ_CompositionElp.section:medicalExamination.entry",
              "display" : "to Appointment or ObservationExamination",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "MedicalExaminationCz.specialistExamination",
          "display" : "A.2.1.4 - Specialist examination",
          "target" : [
            {
              "code" : "CZ_CompositionElp.section:medicalExamination.entry.ofType(CZ_ObservationExaminationElp)",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalExaminationCz",
      "target" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-appointment-elp",
      "element" : [
        {
          "code" : "MedicalExaminationCz.typeOfExamination",
          "display" : "A.2.1.1 - Type of examination",
          "target" : [
            {
              "code" : "CZ_AppointmentElp.serviceCategory",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "MedicalExaminationCz.assessmentByGroup",
          "display" : "A.2.1.2 - Assessment by group",
          "target" : [
            {
              "code" : "CZ_AppointmentElp.serviceType",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "MedicalExaminationCz.examinationDate",
          "display" : "A.2.1.3 - Examination date",
          "target" : [
            {
              "code" : "CZ_AppointmentElp.end",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/elp/StructureDefinition/MedicalExaminationCz",
      "target" : "https://hl7.cz/fhir/elp/StructureDefinition/cz-observation-examination-elp",
      "element" : [
        {
          "code" : "MedicalExaminationCz.specialistExamination.type",
          "display" : "A.2.1.4.1 - Type of examination",
          "target" : [
            {
              "code" : "CZ_ObservationExaminationElp.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "MedicalExaminationCz.specialistExamination.date",
          "display" : "A.2.1.4.2 - Date of examination",
          "target" : [
            {
              "code" : "CZ_ObservationExaminationElp.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
