# Composition: Electronic Medical Report (CZ) - HL7 Czech Electronic medical report Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Composition: Electronic Medical Report (CZ)**

## Example Composition: Composition: Electronic Medical Report (CZ)

Language: cs

Profile: [Composition (ELP CZ)](StructureDefinition-cz-composition-elp.md)

**identifier**: `http://example.org/myhospital/reportidentifiers`/dfkjewoieoijwoskdjg

**status**: Final

**type**: Driver license medical fitness certificate

**date**: 2025-05-20 12:02:00+0100

**author**: [PractitionerRole: specialty = General practitioner](Bundle-cz-example-bundle-electronicmedicalreport.md#urn-uuid-a9c01336-79c9-4e4f-a5c4-5ae9185cef19)

**title**: Electronic Medical Report for patient Mracena

**confidentiality**: normal

**custodian**: [Organization Fakultní nemocnice Oblackov](Bundle-cz-example-bundle-electronicmedicalreport.md#urn-uuid-70df1d8e-4b6b-45ac-a5bf-719960e948bf)



## Resource Content

```json
{
  "resourceType" : "Composition",
  "id" : "543ea990-357a-4514-94d2-e33202cec664",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/elp/StructureDefinition/cz-composition-elp"
    ]
  },
  "language" : "cs",
  "identifier" : {
    "system" : "http://example.org/myhospital/reportidentifiers",
    "value" : "dfkjewoieoijwoskdjg"
  },
  "status" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "104990-7",
        "display" : "Driver license medical fitness certificate"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:2f4dde8e-ad7d-432d-aa49-e995367bbfc3"
  },
  "date" : "2025-05-20T12:02:00+01:00",
  "author" : [
    {
      "reference" : "urn:uuid:a9c01336-79c9-4e4f-a5c4-5ae9185cef19"
    }
  ],
  "title" : "Electronic Medical Report for patient Mracena",
  "confidentiality" : "N",
  "custodian" : {
    "reference" : "urn:uuid:70df1d8e-4b6b-45ac-a5bf-719960e948bf"
  },
  "section" : [
    {
      "title" : "Medical Examination Section",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "56446-8"
          }
        ]
      },
      "entry" : [
        {
          "reference" : "urn:uuid:064c136d-0d08-4b8f-bd76-8d79de3ee99e"
        },
        {
          "reference" : "urn:uuid:777f4db4-4a50-4f89-8bc6-287a59973807"
        }
      ]
    },
    {
      "title" : "Medical Report Section",
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "104988-1"
          }
        ]
      },
      "entry" : [
        {
          "reference" : "urn:uuid:03b0d597-d68d-4966-9400-7752bb3ee39d"
        }
      ]
    }
  ]
}

```
